// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery plan HVR Azure failback input. </summary>
    public partial class RecoveryPlanHyperVReplicaAzureFailbackContent : RecoveryPlanProviderSpecificFailoverContent
    {
        /// <summary> Initializes a new instance of <see cref="RecoveryPlanHyperVReplicaAzureFailbackContent"/>. </summary>
        /// <param name="dataSyncOption"> The data sync option. </param>
        /// <param name="recoveryVmCreationOption"> The ALR option. </param>
        public RecoveryPlanHyperVReplicaAzureFailbackContent(SiteRecoveryDataSyncStatus dataSyncOption, AlternateLocationRecoveryOption recoveryVmCreationOption)
        {
            DataSyncOption = dataSyncOption;
            RecoveryVmCreationOption = recoveryVmCreationOption;
            InstanceType = "HyperVReplicaAzureFailback";
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanHyperVReplicaAzureFailbackContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="dataSyncOption"> The data sync option. </param>
        /// <param name="recoveryVmCreationOption"> The ALR option. </param>
        internal RecoveryPlanHyperVReplicaAzureFailbackContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, SiteRecoveryDataSyncStatus dataSyncOption, AlternateLocationRecoveryOption recoveryVmCreationOption) : base(instanceType, serializedAdditionalRawData)
        {
            DataSyncOption = dataSyncOption;
            RecoveryVmCreationOption = recoveryVmCreationOption;
            InstanceType = instanceType ?? "HyperVReplicaAzureFailback";
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanHyperVReplicaAzureFailbackContent"/> for deserialization. </summary>
        internal RecoveryPlanHyperVReplicaAzureFailbackContent()
        {
        }

        /// <summary> The data sync option. </summary>
        public SiteRecoveryDataSyncStatus DataSyncOption { get; }
        /// <summary> The ALR option. </summary>
        public AlternateLocationRecoveryOption RecoveryVmCreationOption { get; }
    }
}
