// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The group type. </summary>
    public readonly partial struct RecoveryPlanGroupType : IEquatable<RecoveryPlanGroupType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanGroupType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryPlanGroupType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ShutdownValue = "Shutdown";
        private const string BootValue = "Boot";
        private const string FailoverValue = "Failover";

        /// <summary> Shutdown. </summary>
        public static RecoveryPlanGroupType Shutdown { get; } = new RecoveryPlanGroupType(ShutdownValue);
        /// <summary> Boot. </summary>
        public static RecoveryPlanGroupType Boot { get; } = new RecoveryPlanGroupType(BootValue);
        /// <summary> Failover. </summary>
        public static RecoveryPlanGroupType Failover { get; } = new RecoveryPlanGroupType(FailoverValue);
        /// <summary> Determines if two <see cref="RecoveryPlanGroupType"/> values are the same. </summary>
        public static bool operator ==(RecoveryPlanGroupType left, RecoveryPlanGroupType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryPlanGroupType"/> values are not the same. </summary>
        public static bool operator !=(RecoveryPlanGroupType left, RecoveryPlanGroupType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryPlanGroupType"/>. </summary>
        public static implicit operator RecoveryPlanGroupType(string value) => new RecoveryPlanGroupType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryPlanGroupType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryPlanGroupType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
