// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The fabric location. </summary>
    public readonly partial struct RecoveryPlanActionLocation : IEquatable<RecoveryPlanActionLocation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanActionLocation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryPlanActionLocation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string RecoveryValue = "Recovery";

        /// <summary> Primary. </summary>
        public static RecoveryPlanActionLocation Primary { get; } = new RecoveryPlanActionLocation(PrimaryValue);
        /// <summary> Recovery. </summary>
        public static RecoveryPlanActionLocation Recovery { get; } = new RecoveryPlanActionLocation(RecoveryValue);
        /// <summary> Determines if two <see cref="RecoveryPlanActionLocation"/> values are the same. </summary>
        public static bool operator ==(RecoveryPlanActionLocation left, RecoveryPlanActionLocation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryPlanActionLocation"/> values are not the same. </summary>
        public static bool operator !=(RecoveryPlanActionLocation left, RecoveryPlanActionLocation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryPlanActionLocation"/>. </summary>
        public static implicit operator RecoveryPlanActionLocation(string value) => new RecoveryPlanActionLocation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryPlanActionLocation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryPlanActionLocation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
