// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class RecoveryPlanAction : IUtf8JsonSerializable, IJsonModel<RecoveryPlanAction>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecoveryPlanAction>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecoveryPlanAction>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanAction>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecoveryPlanAction)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("actionName"u8);
            writer.WriteStringValue(ActionName);
            writer.WritePropertyName("failoverTypes"u8);
            writer.WriteStartArray();
            foreach (var item in FailoverTypes)
            {
                writer.WriteStringValue(item.ToString());
            }
            writer.WriteEndArray();
            writer.WritePropertyName("failoverDirections"u8);
            writer.WriteStartArray();
            foreach (var item in FailoverDirections)
            {
                writer.WriteStringValue(item.ToString());
            }
            writer.WriteEndArray();
            writer.WritePropertyName("customDetails"u8);
            writer.WriteObjectValue(CustomDetails, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RecoveryPlanAction IJsonModel<RecoveryPlanAction>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanAction>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecoveryPlanAction)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecoveryPlanAction(document.RootElement, options);
        }

        internal static RecoveryPlanAction DeserializeRecoveryPlanAction(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string actionName = default;
            IList<ReplicationProtectedItemOperation> failoverTypes = default;
            IList<PossibleOperationsDirection> failoverDirections = default;
            RecoveryPlanActionDetails customDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("actionName"u8))
                {
                    actionName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("failoverTypes"u8))
                {
                    List<ReplicationProtectedItemOperation> array = new List<ReplicationProtectedItemOperation>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ReplicationProtectedItemOperation(item.GetString()));
                    }
                    failoverTypes = array;
                    continue;
                }
                if (property.NameEquals("failoverDirections"u8))
                {
                    List<PossibleOperationsDirection> array = new List<PossibleOperationsDirection>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new PossibleOperationsDirection(item.GetString()));
                    }
                    failoverDirections = array;
                    continue;
                }
                if (property.NameEquals("customDetails"u8))
                {
                    customDetails = RecoveryPlanActionDetails.DeserializeRecoveryPlanActionDetails(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecoveryPlanAction(actionName, failoverTypes, failoverDirections, customDetails, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RecoveryPlanAction>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanAction>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RecoveryPlanAction)} does not support writing '{options.Format}' format.");
            }
        }

        RecoveryPlanAction IPersistableModel<RecoveryPlanAction>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryPlanAction>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecoveryPlanAction(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecoveryPlanAction)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecoveryPlanAction>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
