// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery plan A2A input. </summary>
    public partial class RecoveryPlanA2AContent : RecoveryPlanProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="RecoveryPlanA2AContent"/>. </summary>
        public RecoveryPlanA2AContent()
        {
            InstanceType = "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPlanA2AContent"/>. </summary>
        /// <param name="instanceType"> Gets the Instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="primaryZone"> The primary zone. </param>
        /// <param name="recoveryZone"> The recovery zone. </param>
        /// <param name="primaryExtendedLocation"> The primary extended location. </param>
        /// <param name="recoveryExtendedLocation"> The recovery extended location. </param>
        internal RecoveryPlanA2AContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string primaryZone, string recoveryZone, SiteRecoveryExtendedLocation primaryExtendedLocation, SiteRecoveryExtendedLocation recoveryExtendedLocation) : base(instanceType, serializedAdditionalRawData)
        {
            PrimaryZone = primaryZone;
            RecoveryZone = recoveryZone;
            PrimaryExtendedLocation = primaryExtendedLocation;
            RecoveryExtendedLocation = recoveryExtendedLocation;
            InstanceType = instanceType ?? "A2A";
        }

        /// <summary> The primary zone. </summary>
        public string PrimaryZone { get; set; }
        /// <summary> The recovery zone. </summary>
        public string RecoveryZone { get; set; }
        /// <summary> The primary extended location. </summary>
        public SiteRecoveryExtendedLocation PrimaryExtendedLocation { get; set; }
        /// <summary> The recovery extended location. </summary>
        public SiteRecoveryExtendedLocation RecoveryExtendedLocation { get; set; }
    }
}
