// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The throughput status. </summary>
    public readonly partial struct RcmComponentStatus : IEquatable<RcmComponentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RcmComponentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RcmComponentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HealthyValue = "Healthy";
        private const string WarningValue = "Warning";
        private const string CriticalValue = "Critical";
        private const string UnknownValue = "Unknown";

        /// <summary> Healthy. </summary>
        public static RcmComponentStatus Healthy { get; } = new RcmComponentStatus(HealthyValue);
        /// <summary> Warning. </summary>
        public static RcmComponentStatus Warning { get; } = new RcmComponentStatus(WarningValue);
        /// <summary> Critical. </summary>
        public static RcmComponentStatus Critical { get; } = new RcmComponentStatus(CriticalValue);
        /// <summary> Unknown. </summary>
        public static RcmComponentStatus Unknown { get; } = new RcmComponentStatus(UnknownValue);
        /// <summary> Determines if two <see cref="RcmComponentStatus"/> values are the same. </summary>
        public static bool operator ==(RcmComponentStatus left, RcmComponentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RcmComponentStatus"/> values are not the same. </summary>
        public static bool operator !=(RcmComponentStatus left, RcmComponentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RcmComponentStatus"/>. </summary>
        public static implicit operator RcmComponentStatus(string value) => new RcmComponentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RcmComponentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RcmComponentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
