// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The PossibleOperationsDirection. </summary>
    public readonly partial struct PossibleOperationsDirection : IEquatable<PossibleOperationsDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PossibleOperationsDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PossibleOperationsDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryToRecoveryValue = "PrimaryToRecovery";
        private const string RecoveryToPrimaryValue = "RecoveryToPrimary";

        /// <summary> PrimaryToRecovery. </summary>
        public static PossibleOperationsDirection PrimaryToRecovery { get; } = new PossibleOperationsDirection(PrimaryToRecoveryValue);
        /// <summary> RecoveryToPrimary. </summary>
        public static PossibleOperationsDirection RecoveryToPrimary { get; } = new PossibleOperationsDirection(RecoveryToPrimaryValue);
        /// <summary> Determines if two <see cref="PossibleOperationsDirection"/> values are the same. </summary>
        public static bool operator ==(PossibleOperationsDirection left, PossibleOperationsDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PossibleOperationsDirection"/> values are not the same. </summary>
        public static bool operator !=(PossibleOperationsDirection left, PossibleOperationsDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PossibleOperationsDirection"/>. </summary>
        public static implicit operator PossibleOperationsDirection(string value) => new PossibleOperationsDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PossibleOperationsDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PossibleOperationsDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
