// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Recovery virtual network input to create new virtual network from given source network. </summary>
    public partial class NewRecoveryVirtualNetwork : RecoveryVirtualNetworkCustomDetails
    {
        /// <summary> Initializes a new instance of <see cref="NewRecoveryVirtualNetwork"/>. </summary>
        public NewRecoveryVirtualNetwork()
        {
            ResourceType = "New";
        }

        /// <summary> Initializes a new instance of <see cref="NewRecoveryVirtualNetwork"/>. </summary>
        /// <param name="resourceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryVirtualNetworkResourceGroupName"> The name of the resource group to be used to create the recovery virtual network. If absent, target network would be created in the same resource group as target VM. </param>
        /// <param name="recoveryVirtualNetworkName"> The recovery virtual network name. </param>
        internal NewRecoveryVirtualNetwork(string resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string recoveryVirtualNetworkResourceGroupName, string recoveryVirtualNetworkName) : base(resourceType, serializedAdditionalRawData)
        {
            RecoveryVirtualNetworkResourceGroupName = recoveryVirtualNetworkResourceGroupName;
            RecoveryVirtualNetworkName = recoveryVirtualNetworkName;
            ResourceType = resourceType ?? "New";
        }

        /// <summary> The name of the resource group to be used to create the recovery virtual network. If absent, target network would be created in the same resource group as target VM. </summary>
        public string RecoveryVirtualNetworkResourceGroupName { get; set; }
        /// <summary> The recovery virtual network name. </summary>
        public string RecoveryVirtualNetworkName { get; set; }
    }
}
