// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Whether Multi VM group is auto created or specified by user. </summary>
    public readonly partial struct MultiVmGroupCreateOption : IEquatable<MultiVmGroupCreateOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MultiVmGroupCreateOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MultiVmGroupCreateOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoCreatedValue = "AutoCreated";
        private const string UserSpecifiedValue = "UserSpecified";

        /// <summary> AutoCreated. </summary>
        public static MultiVmGroupCreateOption AutoCreated { get; } = new MultiVmGroupCreateOption(AutoCreatedValue);
        /// <summary> UserSpecified. </summary>
        public static MultiVmGroupCreateOption UserSpecified { get; } = new MultiVmGroupCreateOption(UserSpecifiedValue);
        /// <summary> Determines if two <see cref="MultiVmGroupCreateOption"/> values are the same. </summary>
        public static bool operator ==(MultiVmGroupCreateOption left, MultiVmGroupCreateOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MultiVmGroupCreateOption"/> values are not the same. </summary>
        public static bool operator !=(MultiVmGroupCreateOption left, MultiVmGroupCreateOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MultiVmGroupCreateOption"/>. </summary>
        public static implicit operator MultiVmGroupCreateOption(string value) => new MultiVmGroupCreateOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MultiVmGroupCreateOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MultiVmGroupCreateOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
