// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The agent auto upgrade state. </summary>
    public readonly partial struct MobilityAgentUpgradeState : IEquatable<MobilityAgentUpgradeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MobilityAgentUpgradeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MobilityAgentUpgradeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string StartedValue = "Started";
        private const string CompletedValue = "Completed";
        private const string CommitValue = "Commit";

        /// <summary> None. </summary>
        public static MobilityAgentUpgradeState None { get; } = new MobilityAgentUpgradeState(NoneValue);
        /// <summary> Started. </summary>
        public static MobilityAgentUpgradeState Started { get; } = new MobilityAgentUpgradeState(StartedValue);
        /// <summary> Completed. </summary>
        public static MobilityAgentUpgradeState Completed { get; } = new MobilityAgentUpgradeState(CompletedValue);
        /// <summary> Commit. </summary>
        public static MobilityAgentUpgradeState Commit { get; } = new MobilityAgentUpgradeState(CommitValue);
        /// <summary> Determines if two <see cref="MobilityAgentUpgradeState"/> values are the same. </summary>
        public static bool operator ==(MobilityAgentUpgradeState left, MobilityAgentUpgradeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MobilityAgentUpgradeState"/> values are not the same. </summary>
        public static bool operator !=(MobilityAgentUpgradeState left, MobilityAgentUpgradeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MobilityAgentUpgradeState"/>. </summary>
        public static implicit operator MobilityAgentUpgradeState(string value) => new MobilityAgentUpgradeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MobilityAgentUpgradeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MobilityAgentUpgradeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
