// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> This class represents the manual action task details. </summary>
    public partial class ManualActionTaskDetails : SiteRecoveryTaskTypeDetails
    {
        /// <summary> Initializes a new instance of <see cref="ManualActionTaskDetails"/>. </summary>
        internal ManualActionTaskDetails()
        {
            InstanceType = "ManualActionTaskDetails";
        }

        /// <summary> Initializes a new instance of <see cref="ManualActionTaskDetails"/>. </summary>
        /// <param name="instanceType"> The type of task details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> The name. </param>
        /// <param name="instructions"> The instructions. </param>
        /// <param name="observation"> The observation. </param>
        internal ManualActionTaskDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, string instructions, string observation) : base(instanceType, serializedAdditionalRawData)
        {
            Name = name;
            Instructions = instructions;
            Observation = observation;
            InstanceType = instanceType ?? "ManualActionTaskDetails";
        }

        /// <summary> The name. </summary>
        public string Name { get; }
        /// <summary> The instructions. </summary>
        public string Instructions { get; }
        /// <summary> The observation. </summary>
        public string Observation { get; }
    }
}
