// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> This class represents the inline workflow task details. </summary>
    public partial class InlineWorkflowTaskDetails : SiteRecoveryGroupTaskDetails
    {
        /// <summary> Initializes a new instance of <see cref="InlineWorkflowTaskDetails"/>. </summary>
        internal InlineWorkflowTaskDetails()
        {
            WorkflowIds = new ChangeTrackingList<string>();
            InstanceType = "InlineWorkflowTaskDetails";
        }

        /// <summary> Initializes a new instance of <see cref="InlineWorkflowTaskDetails"/>. </summary>
        /// <param name="instanceType"> The type of task details. </param>
        /// <param name="childTasks"> The child tasks. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="workflowIds"> The list of child workflow ids. </param>
        internal InlineWorkflowTaskDetails(string instanceType, IReadOnlyList<AsrTask> childTasks, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<string> workflowIds) : base(instanceType, childTasks, serializedAdditionalRawData)
        {
            WorkflowIds = workflowIds;
            InstanceType = instanceType ?? "InlineWorkflowTaskDetails";
        }

        /// <summary> The list of child workflow ids. </summary>
        public IReadOnlyList<string> WorkflowIds { get; }
    }
}
