// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Initial replication details. </summary>
    public partial class InitialReplicationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InitialReplicationDetails"/>. </summary>
        internal InitialReplicationDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InitialReplicationDetails"/>. </summary>
        /// <param name="initialReplicationType"> Initial replication type. </param>
        /// <param name="initialReplicationProgressPercentage"> The initial replication progress percentage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InitialReplicationDetails(string initialReplicationType, string initialReplicationProgressPercentage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InitialReplicationType = initialReplicationType;
            InitialReplicationProgressPercentage = initialReplicationProgressPercentage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initial replication type. </summary>
        public string InitialReplicationType { get; }
        /// <summary> The initial replication progress percentage. </summary>
        public string InitialReplicationProgressPercentage { get; }
    }
}
