// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> This class stores the monitoring details for consistency check of inconsistent Protected Entity. </summary>
    public partial class InconsistentVmDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InconsistentVmDetails"/>. </summary>
        internal InconsistentVmDetails()
        {
            Details = new ChangeTrackingList<string>();
            ErrorIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="InconsistentVmDetails"/>. </summary>
        /// <param name="vmName"> The Vm name. </param>
        /// <param name="cloudName"> The Cloud name. </param>
        /// <param name="details"> The list of details regarding state of the Protected Entity in SRS and On prem. </param>
        /// <param name="errorIds"> The list of error ids. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InconsistentVmDetails(string vmName, string cloudName, IReadOnlyList<string> details, IReadOnlyList<string> errorIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmName = vmName;
            CloudName = cloudName;
            Details = details;
            ErrorIds = errorIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Vm name. </summary>
        public string VmName { get; }
        /// <summary> The Cloud name. </summary>
        public string CloudName { get; }
        /// <summary> The list of details regarding state of the Protected Entity in SRS and On prem. </summary>
        public IReadOnlyList<string> Details { get; }
        /// <summary> The list of error ids. </summary>
        public IReadOnlyList<string> ErrorIds { get; }
    }
}
