// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. </summary>
    public readonly partial struct InMageV2RpRecoveryPointType : IEquatable<InMageV2RpRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InMageV2RpRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InMageV2RpRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestValue = "Latest";
        private const string LatestApplicationConsistentValue = "LatestApplicationConsistent";
        private const string LatestCrashConsistentValue = "LatestCrashConsistent";
        private const string LatestProcessedValue = "LatestProcessed";

        /// <summary> Latest. </summary>
        public static InMageV2RpRecoveryPointType Latest { get; } = new InMageV2RpRecoveryPointType(LatestValue);
        /// <summary> LatestApplicationConsistent. </summary>
        public static InMageV2RpRecoveryPointType LatestApplicationConsistent { get; } = new InMageV2RpRecoveryPointType(LatestApplicationConsistentValue);
        /// <summary> LatestCrashConsistent. </summary>
        public static InMageV2RpRecoveryPointType LatestCrashConsistent { get; } = new InMageV2RpRecoveryPointType(LatestCrashConsistentValue);
        /// <summary> LatestProcessed. </summary>
        public static InMageV2RpRecoveryPointType LatestProcessed { get; } = new InMageV2RpRecoveryPointType(LatestProcessedValue);
        /// <summary> Determines if two <see cref="InMageV2RpRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(InMageV2RpRecoveryPointType left, InMageV2RpRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InMageV2RpRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(InMageV2RpRecoveryPointType left, InMageV2RpRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InMageV2RpRecoveryPointType"/>. </summary>
        public static implicit operator InMageV2RpRecoveryPointType(string value) => new InMageV2RpRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InMageV2RpRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InMageV2RpRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
