// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class InMageReprotectContent : IUtf8JsonSerializable, IJsonModel<InMageReprotectContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InMageReprotectContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InMageReprotectContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageReprotectContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InMageReprotectContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("masterTargetId"u8);
            writer.WriteStringValue(MasterTargetId);
            writer.WritePropertyName("processServerId"u8);
            writer.WriteStringValue(ProcessServerId);
            writer.WritePropertyName("retentionDrive"u8);
            writer.WriteStringValue(RetentionDrive);
            if (Optional.IsDefined(RunAsAccountId))
            {
                writer.WritePropertyName("runAsAccountId"u8);
                writer.WriteStringValue(RunAsAccountId);
            }
            if (Optional.IsDefined(DatastoreName))
            {
                writer.WritePropertyName("datastoreName"u8);
                writer.WriteStringValue(DatastoreName);
            }
            if (Optional.IsDefined(DiskExclusionContent))
            {
                writer.WritePropertyName("diskExclusionInput"u8);
                writer.WriteObjectValue(DiskExclusionContent, options);
            }
            writer.WritePropertyName("profileId"u8);
            writer.WriteStringValue(ProfileId);
            if (Optional.IsCollectionDefined(DisksToInclude))
            {
                writer.WritePropertyName("disksToInclude"u8);
                writer.WriteStartArray();
                foreach (var item in DisksToInclude)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
        }

        InMageReprotectContent IJsonModel<InMageReprotectContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageReprotectContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InMageReprotectContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInMageReprotectContent(document.RootElement, options);
        }

        internal static InMageReprotectContent DeserializeInMageReprotectContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string masterTargetId = default;
            Guid processServerId = default;
            string retentionDrive = default;
            string runAsAccountId = default;
            string datastoreName = default;
            InMageDiskExclusionContent diskExclusionContent = default;
            string profileId = default;
            IList<string> disksToInclude = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("masterTargetId"u8))
                {
                    masterTargetId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("processServerId"u8))
                {
                    processServerId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("retentionDrive"u8))
                {
                    retentionDrive = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("runAsAccountId"u8))
                {
                    runAsAccountId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("datastoreName"u8))
                {
                    datastoreName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskExclusionInput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskExclusionContent = InMageDiskExclusionContent.DeserializeInMageDiskExclusionContent(property.Value, options);
                    continue;
                }
                if (property.NameEquals("profileId"u8))
                {
                    profileId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("disksToInclude"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    disksToInclude = array;
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InMageReprotectContent(
                instanceType,
                serializedAdditionalRawData,
                masterTargetId,
                processServerId,
                retentionDrive,
                runAsAccountId,
                datastoreName,
                diskExclusionContent,
                profileId,
                disksToInclude ?? new ChangeTrackingList<string>());
        }

        BinaryData IPersistableModel<InMageReprotectContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageReprotectContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InMageReprotectContent)} does not support writing '{options.Format}' format.");
            }
        }

        InMageReprotectContent IPersistableModel<InMageReprotectContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageReprotectContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInMageReprotectContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InMageReprotectContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InMageReprotectContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
