// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageRcm provider specific input for unplanned failover. </summary>
    public partial class InMageRcmUnplannedFailoverContent : UnplannedFailoverProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="InMageRcmUnplannedFailoverContent"/>. </summary>
        /// <param name="performShutdown"> A value indicating whether VM is to be shutdown. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="performShutdown"/> is null. </exception>
        public InMageRcmUnplannedFailoverContent(string performShutdown)
        {
            Argument.AssertNotNull(performShutdown, nameof(performShutdown));

            PerformShutdown = performShutdown;
            InstanceType = "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmUnplannedFailoverContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="performShutdown"> A value indicating whether VM is to be shutdown. </param>
        /// <param name="recoveryPointId"> The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed. </param>
        internal InMageRcmUnplannedFailoverContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string performShutdown, ResourceIdentifier recoveryPointId) : base(instanceType, serializedAdditionalRawData)
        {
            PerformShutdown = performShutdown;
            RecoveryPointId = recoveryPointId;
            InstanceType = instanceType ?? "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmUnplannedFailoverContent"/> for deserialization. </summary>
        internal InMageRcmUnplannedFailoverContent()
        {
        }

        /// <summary> A value indicating whether VM is to be shutdown. </summary>
        public string PerformShutdown { get; }
        /// <summary> The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed. </summary>
        public ResourceIdentifier RecoveryPointId { get; set; }
    }
}
