// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageRcm provider specific details. </summary>
    public partial class InMageRcmReplicationDetails : ReplicationProviderSpecificSettings
    {
        /// <summary> Initializes a new instance of <see cref="InMageRcmReplicationDetails"/>. </summary>
        internal InMageRcmReplicationDetails()
        {
            ProtectedDisks = new ChangeTrackingList<InMageRcmProtectedDiskDetails>();
            LastAgentUpgradeErrorDetails = new ChangeTrackingList<InMageRcmLastAgentUpgradeErrorDetails>();
            AgentUpgradeBlockingErrorDetails = new ChangeTrackingList<InMageRcmAgentUpgradeBlockingErrorDetails>();
            VmNics = new ChangeTrackingList<InMageRcmNicDetails>();
            InstanceType = "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmReplicationDetails"/>. </summary>
        /// <param name="instanceType"> Gets the Instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="internalIdentifier"> The virtual machine internal identifier. </param>
        /// <param name="fabricDiscoveryMachineId"> The ARM Id of the discovered VM. </param>
        /// <param name="multiVmGroupName"> The multi VM group name. </param>
        /// <param name="discoveryType"> The type of the discovered VM. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="processorCoreCount"> The processor core count. </param>
        /// <param name="allocatedMemoryInMB"> The allocated memory in MB. </param>
        /// <param name="processServerName"> The process server name. </param>
        /// <param name="runAsAccountId"> The run-as account Id. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="firmwareType"> The firmware type. </param>
        /// <param name="primaryNicIPAddress"> The IP address of the primary network interface. </param>
        /// <param name="targetGeneration"> The target generation. </param>
        /// <param name="licenseType"> License Type of the VM to be used. </param>
        /// <param name="storageAccountId"> The replication storage account ARM Id. This is applicable only for the blob based replication test hook. </param>
        /// <param name="targetVmName"> Target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="targetResourceGroupId"> The target resource group Id. </param>
        /// <param name="targetLocation"> The target location. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="targetNetworkId"> The target network Id. </param>
        /// <param name="testNetworkId"> The test network Id. </param>
        /// <param name="failoverRecoveryPointId"> The recovery point Id to which the VM was failed over. </param>
        /// <param name="lastRecoveryPointReceived"> The last recovery point received time. </param>
        /// <param name="lastRpoInSeconds"> The last recovery point objective value. </param>
        /// <param name="lastRpoCalculatedOn"> The last recovery point objective calculated time. </param>
        /// <param name="lastRecoveryPointId"> The last recovery point Id. </param>
        /// <param name="initialReplicationProgressPercentage"> The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM. </param>
        /// <param name="initialReplicationProcessedBytes"> The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </param>
        /// <param name="initialReplicationTransferredBytes"> The initial replication transferred bytes from source VM to azure for all selected disks on source VM. </param>
        /// <param name="initialReplicationProgressHealth"> The initial replication progress health. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM. </param>
        /// <param name="resyncProcessedBytes"> The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </param>
        /// <param name="resyncTransferredBytes"> The resync transferred bytes from source VM to azure for all selected disks on source VM. </param>
        /// <param name="resyncProgressHealth"> The resync progress health. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required. </param>
        /// <param name="resyncState"> The resync state. </param>
        /// <param name="agentUpgradeState"> The agent auto upgrade state. </param>
        /// <param name="lastAgentUpgradeType"> The last agent upgrade type. </param>
        /// <param name="agentUpgradeJobId"> The agent upgrade job Id. </param>
        /// <param name="agentUpgradeAttemptToVersion"> The agent version to which last agent upgrade was attempted. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="isLastUpgradeSuccessful"> A value indicating whether last agent upgrade was successful or not. </param>
        /// <param name="isAgentRegistrationSuccessfulAfterFailover"> A value indicating whether agent registration was successful after failover. </param>
        /// <param name="mobilityAgentDetails"> The mobility agent information. </param>
        /// <param name="lastAgentUpgradeErrorDetails"> The last agent upgrade error information. </param>
        /// <param name="agentUpgradeBlockingErrorDetails"> The agent upgrade blocking error information. </param>
        /// <param name="vmNics"> The network details. </param>
        /// <param name="discoveredVmDetails"> The discovered VM details. </param>
        internal InMageRcmReplicationDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string internalIdentifier, string fabricDiscoveryMachineId, string multiVmGroupName, string discoveryType, Guid? processServerId, int? processorCoreCount, double? allocatedMemoryInMB, string processServerName, string runAsAccountId, string osType, string firmwareType, IPAddress primaryNicIPAddress, string targetGeneration, string licenseType, ResourceIdentifier storageAccountId, string targetVmName, string targetVmSize, ResourceIdentifier targetResourceGroupId, string targetLocation, ResourceIdentifier targetAvailabilitySetId, string targetAvailabilityZone, ResourceIdentifier targetProximityPlacementGroupId, ResourceIdentifier targetBootDiagnosticsStorageAccountId, ResourceIdentifier targetNetworkId, ResourceIdentifier testNetworkId, ResourceIdentifier failoverRecoveryPointId, DateTimeOffset? lastRecoveryPointReceived, long? lastRpoInSeconds, DateTimeOffset? lastRpoCalculatedOn, ResourceIdentifier lastRecoveryPointId, int? initialReplicationProgressPercentage, long? initialReplicationProcessedBytes, long? initialReplicationTransferredBytes, VmReplicationProgressHealth? initialReplicationProgressHealth, int? resyncProgressPercentage, long? resyncProcessedBytes, long? resyncTransferredBytes, VmReplicationProgressHealth? resyncProgressHealth, string resyncRequired, SiteRecoveryResyncState? resyncState, MobilityAgentUpgradeState? agentUpgradeState, string lastAgentUpgradeType, string agentUpgradeJobId, string agentUpgradeAttemptToVersion, IReadOnlyList<InMageRcmProtectedDiskDetails> protectedDisks, string isLastUpgradeSuccessful, bool? isAgentRegistrationSuccessfulAfterFailover, InMageRcmMobilityAgentDetails mobilityAgentDetails, IReadOnlyList<InMageRcmLastAgentUpgradeErrorDetails> lastAgentUpgradeErrorDetails, IReadOnlyList<InMageRcmAgentUpgradeBlockingErrorDetails> agentUpgradeBlockingErrorDetails, IReadOnlyList<InMageRcmNicDetails> vmNics, InMageRcmDiscoveredProtectedVmDetails discoveredVmDetails) : base(instanceType, serializedAdditionalRawData)
        {
            InternalIdentifier = internalIdentifier;
            FabricDiscoveryMachineId = fabricDiscoveryMachineId;
            MultiVmGroupName = multiVmGroupName;
            DiscoveryType = discoveryType;
            ProcessServerId = processServerId;
            ProcessorCoreCount = processorCoreCount;
            AllocatedMemoryInMB = allocatedMemoryInMB;
            ProcessServerName = processServerName;
            RunAsAccountId = runAsAccountId;
            OSType = osType;
            FirmwareType = firmwareType;
            PrimaryNicIPAddress = primaryNicIPAddress;
            TargetGeneration = targetGeneration;
            LicenseType = licenseType;
            StorageAccountId = storageAccountId;
            TargetVmName = targetVmName;
            TargetVmSize = targetVmSize;
            TargetResourceGroupId = targetResourceGroupId;
            TargetLocation = targetLocation;
            TargetAvailabilitySetId = targetAvailabilitySetId;
            TargetAvailabilityZone = targetAvailabilityZone;
            TargetProximityPlacementGroupId = targetProximityPlacementGroupId;
            TargetBootDiagnosticsStorageAccountId = targetBootDiagnosticsStorageAccountId;
            TargetNetworkId = targetNetworkId;
            TestNetworkId = testNetworkId;
            FailoverRecoveryPointId = failoverRecoveryPointId;
            LastRecoveryPointReceived = lastRecoveryPointReceived;
            LastRpoInSeconds = lastRpoInSeconds;
            LastRpoCalculatedOn = lastRpoCalculatedOn;
            LastRecoveryPointId = lastRecoveryPointId;
            InitialReplicationProgressPercentage = initialReplicationProgressPercentage;
            InitialReplicationProcessedBytes = initialReplicationProcessedBytes;
            InitialReplicationTransferredBytes = initialReplicationTransferredBytes;
            InitialReplicationProgressHealth = initialReplicationProgressHealth;
            ResyncProgressPercentage = resyncProgressPercentage;
            ResyncProcessedBytes = resyncProcessedBytes;
            ResyncTransferredBytes = resyncTransferredBytes;
            ResyncProgressHealth = resyncProgressHealth;
            ResyncRequired = resyncRequired;
            ResyncState = resyncState;
            AgentUpgradeState = agentUpgradeState;
            LastAgentUpgradeType = lastAgentUpgradeType;
            AgentUpgradeJobId = agentUpgradeJobId;
            AgentUpgradeAttemptToVersion = agentUpgradeAttemptToVersion;
            ProtectedDisks = protectedDisks;
            IsLastUpgradeSuccessful = isLastUpgradeSuccessful;
            IsAgentRegistrationSuccessfulAfterFailover = isAgentRegistrationSuccessfulAfterFailover;
            MobilityAgentDetails = mobilityAgentDetails;
            LastAgentUpgradeErrorDetails = lastAgentUpgradeErrorDetails;
            AgentUpgradeBlockingErrorDetails = agentUpgradeBlockingErrorDetails;
            VmNics = vmNics;
            DiscoveredVmDetails = discoveredVmDetails;
            InstanceType = instanceType ?? "InMageRcm";
        }

        /// <summary> The virtual machine internal identifier. </summary>
        public string InternalIdentifier { get; }
        /// <summary> The ARM Id of the discovered VM. </summary>
        public string FabricDiscoveryMachineId { get; }
        /// <summary> The multi VM group name. </summary>
        public string MultiVmGroupName { get; }
        /// <summary> The type of the discovered VM. </summary>
        public string DiscoveryType { get; }
        /// <summary> The process server Id. </summary>
        public Guid? ProcessServerId { get; }
        /// <summary> The processor core count. </summary>
        public int? ProcessorCoreCount { get; }
        /// <summary> The allocated memory in MB. </summary>
        public double? AllocatedMemoryInMB { get; }
        /// <summary> The process server name. </summary>
        public string ProcessServerName { get; }
        /// <summary> The run-as account Id. </summary>
        public string RunAsAccountId { get; }
        /// <summary> The type of the OS on the VM. </summary>
        public string OSType { get; }
        /// <summary> The firmware type. </summary>
        public string FirmwareType { get; }
        /// <summary> The IP address of the primary network interface. </summary>
        public IPAddress PrimaryNicIPAddress { get; }
        /// <summary> The target generation. </summary>
        public string TargetGeneration { get; }
        /// <summary> License Type of the VM to be used. </summary>
        public string LicenseType { get; }
        /// <summary> The replication storage account ARM Id. This is applicable only for the blob based replication test hook. </summary>
        public ResourceIdentifier StorageAccountId { get; }
        /// <summary> Target VM name. </summary>
        public string TargetVmName { get; }
        /// <summary> The target VM size. </summary>
        public string TargetVmSize { get; }
        /// <summary> The target resource group Id. </summary>
        public ResourceIdentifier TargetResourceGroupId { get; }
        /// <summary> The target location. </summary>
        public string TargetLocation { get; }
        /// <summary> The target availability set Id. </summary>
        public ResourceIdentifier TargetAvailabilitySetId { get; }
        /// <summary> The target availability zone. </summary>
        public string TargetAvailabilityZone { get; }
        /// <summary> The target proximity placement group Id. </summary>
        public ResourceIdentifier TargetProximityPlacementGroupId { get; }
        /// <summary> The target boot diagnostics storage account ARM Id. </summary>
        public ResourceIdentifier TargetBootDiagnosticsStorageAccountId { get; }
        /// <summary> The target network Id. </summary>
        public ResourceIdentifier TargetNetworkId { get; }
        /// <summary> The test network Id. </summary>
        public ResourceIdentifier TestNetworkId { get; }
        /// <summary> The recovery point Id to which the VM was failed over. </summary>
        public ResourceIdentifier FailoverRecoveryPointId { get; }
        /// <summary> The last recovery point received time. </summary>
        public DateTimeOffset? LastRecoveryPointReceived { get; }
        /// <summary> The last recovery point objective value. </summary>
        public long? LastRpoInSeconds { get; }
        /// <summary> The last recovery point objective calculated time. </summary>
        public DateTimeOffset? LastRpoCalculatedOn { get; }
        /// <summary> The last recovery point Id. </summary>
        public ResourceIdentifier LastRecoveryPointId { get; }
        /// <summary> The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM. </summary>
        public int? InitialReplicationProgressPercentage { get; }
        /// <summary> The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </summary>
        public long? InitialReplicationProcessedBytes { get; }
        /// <summary> The initial replication transferred bytes from source VM to azure for all selected disks on source VM. </summary>
        public long? InitialReplicationTransferredBytes { get; }
        /// <summary> The initial replication progress health. </summary>
        public VmReplicationProgressHealth? InitialReplicationProgressHealth { get; }
        /// <summary> The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM. </summary>
        public int? ResyncProgressPercentage { get; }
        /// <summary> The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </summary>
        public long? ResyncProcessedBytes { get; }
        /// <summary> The resync transferred bytes from source VM to azure for all selected disks on source VM. </summary>
        public long? ResyncTransferredBytes { get; }
        /// <summary> The resync progress health. </summary>
        public VmReplicationProgressHealth? ResyncProgressHealth { get; }
        /// <summary> A value indicating whether resync is required. </summary>
        public string ResyncRequired { get; }
        /// <summary> The resync state. </summary>
        public SiteRecoveryResyncState? ResyncState { get; }
        /// <summary> The agent auto upgrade state. </summary>
        public MobilityAgentUpgradeState? AgentUpgradeState { get; }
        /// <summary> The last agent upgrade type. </summary>
        public string LastAgentUpgradeType { get; }
        /// <summary> The agent upgrade job Id. </summary>
        public string AgentUpgradeJobId { get; }
        /// <summary> The agent version to which last agent upgrade was attempted. </summary>
        public string AgentUpgradeAttemptToVersion { get; }
        /// <summary> The list of protected disks. </summary>
        public IReadOnlyList<InMageRcmProtectedDiskDetails> ProtectedDisks { get; }
        /// <summary> A value indicating whether last agent upgrade was successful or not. </summary>
        public string IsLastUpgradeSuccessful { get; }
        /// <summary> A value indicating whether agent registration was successful after failover. </summary>
        public bool? IsAgentRegistrationSuccessfulAfterFailover { get; }
        /// <summary> The mobility agent information. </summary>
        public InMageRcmMobilityAgentDetails MobilityAgentDetails { get; }
        /// <summary> The last agent upgrade error information. </summary>
        public IReadOnlyList<InMageRcmLastAgentUpgradeErrorDetails> LastAgentUpgradeErrorDetails { get; }
        /// <summary> The agent upgrade blocking error information. </summary>
        public IReadOnlyList<InMageRcmAgentUpgradeBlockingErrorDetails> AgentUpgradeBlockingErrorDetails { get; }
        /// <summary> The network details. </summary>
        public IReadOnlyList<InMageRcmNicDetails> VmNics { get; }
        /// <summary> The discovered VM details. </summary>
        public InMageRcmDiscoveredProtectedVmDetails DiscoveredVmDetails { get; }
    }
}
