// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Net;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class InMageRcmReplicationDetails : IUtf8JsonSerializable, IJsonModel<InMageRcmReplicationDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InMageRcmReplicationDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InMageRcmReplicationDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InMageRcmReplicationDetails)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(InternalIdentifier))
            {
                writer.WritePropertyName("internalIdentifier"u8);
                writer.WriteStringValue(InternalIdentifier);
            }
            if (options.Format != "W" && Optional.IsDefined(FabricDiscoveryMachineId))
            {
                writer.WritePropertyName("fabricDiscoveryMachineId"u8);
                writer.WriteStringValue(FabricDiscoveryMachineId);
            }
            if (options.Format != "W" && Optional.IsDefined(MultiVmGroupName))
            {
                writer.WritePropertyName("multiVmGroupName"u8);
                writer.WriteStringValue(MultiVmGroupName);
            }
            if (options.Format != "W" && Optional.IsDefined(DiscoveryType))
            {
                writer.WritePropertyName("discoveryType"u8);
                writer.WriteStringValue(DiscoveryType);
            }
            if (options.Format != "W" && Optional.IsDefined(ProcessServerId))
            {
                writer.WritePropertyName("processServerId"u8);
                writer.WriteStringValue(ProcessServerId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProcessorCoreCount))
            {
                writer.WritePropertyName("processorCoreCount"u8);
                writer.WriteNumberValue(ProcessorCoreCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AllocatedMemoryInMB))
            {
                writer.WritePropertyName("allocatedMemoryInMB"u8);
                writer.WriteNumberValue(AllocatedMemoryInMB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProcessServerName))
            {
                writer.WritePropertyName("processServerName"u8);
                writer.WriteStringValue(ProcessServerName);
            }
            if (options.Format != "W" && Optional.IsDefined(RunAsAccountId))
            {
                writer.WritePropertyName("runAsAccountId"u8);
                writer.WriteStringValue(RunAsAccountId);
            }
            if (options.Format != "W" && Optional.IsDefined(OSType))
            {
                writer.WritePropertyName("osType"u8);
                writer.WriteStringValue(OSType);
            }
            if (options.Format != "W" && Optional.IsDefined(FirmwareType))
            {
                writer.WritePropertyName("firmwareType"u8);
                writer.WriteStringValue(FirmwareType);
            }
            if (options.Format != "W" && Optional.IsDefined(PrimaryNicIPAddress))
            {
                writer.WritePropertyName("primaryNicIpAddress"u8);
                writer.WriteStringValue(PrimaryNicIPAddress.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(TargetGeneration))
            {
                writer.WritePropertyName("targetGeneration"u8);
                writer.WriteStringValue(TargetGeneration);
            }
            if (Optional.IsDefined(LicenseType))
            {
                writer.WritePropertyName("licenseType"u8);
                writer.WriteStringValue(LicenseType);
            }
            if (options.Format != "W" && Optional.IsDefined(StorageAccountId))
            {
                writer.WritePropertyName("storageAccountId"u8);
                writer.WriteStringValue(StorageAccountId);
            }
            if (Optional.IsDefined(TargetVmName))
            {
                writer.WritePropertyName("targetVmName"u8);
                writer.WriteStringValue(TargetVmName);
            }
            if (Optional.IsDefined(TargetVmSize))
            {
                writer.WritePropertyName("targetVmSize"u8);
                writer.WriteStringValue(TargetVmSize);
            }
            if (Optional.IsDefined(TargetResourceGroupId))
            {
                writer.WritePropertyName("targetResourceGroupId"u8);
                writer.WriteStringValue(TargetResourceGroupId);
            }
            if (Optional.IsDefined(TargetLocation))
            {
                writer.WritePropertyName("targetLocation"u8);
                writer.WriteStringValue(TargetLocation);
            }
            if (Optional.IsDefined(TargetAvailabilitySetId))
            {
                writer.WritePropertyName("targetAvailabilitySetId"u8);
                writer.WriteStringValue(TargetAvailabilitySetId);
            }
            if (Optional.IsDefined(TargetAvailabilityZone))
            {
                writer.WritePropertyName("targetAvailabilityZone"u8);
                writer.WriteStringValue(TargetAvailabilityZone);
            }
            if (Optional.IsDefined(TargetProximityPlacementGroupId))
            {
                writer.WritePropertyName("targetProximityPlacementGroupId"u8);
                writer.WriteStringValue(TargetProximityPlacementGroupId);
            }
            if (Optional.IsDefined(TargetBootDiagnosticsStorageAccountId))
            {
                writer.WritePropertyName("targetBootDiagnosticsStorageAccountId"u8);
                writer.WriteStringValue(TargetBootDiagnosticsStorageAccountId);
            }
            if (Optional.IsDefined(TargetNetworkId))
            {
                writer.WritePropertyName("targetNetworkId"u8);
                writer.WriteStringValue(TargetNetworkId);
            }
            if (Optional.IsDefined(TestNetworkId))
            {
                writer.WritePropertyName("testNetworkId"u8);
                writer.WriteStringValue(TestNetworkId);
            }
            if (options.Format != "W" && Optional.IsDefined(FailoverRecoveryPointId))
            {
                writer.WritePropertyName("failoverRecoveryPointId"u8);
                writer.WriteStringValue(FailoverRecoveryPointId);
            }
            if (options.Format != "W" && Optional.IsDefined(LastRecoveryPointReceived))
            {
                writer.WritePropertyName("lastRecoveryPointReceived"u8);
                writer.WriteStringValue(LastRecoveryPointReceived.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRpoInSeconds))
            {
                writer.WritePropertyName("lastRpoInSeconds"u8);
                writer.WriteNumberValue(LastRpoInSeconds.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LastRpoCalculatedOn))
            {
                writer.WritePropertyName("lastRpoCalculatedTime"u8);
                writer.WriteStringValue(LastRpoCalculatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRecoveryPointId))
            {
                writer.WritePropertyName("lastRecoveryPointId"u8);
                writer.WriteStringValue(LastRecoveryPointId);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProgressPercentage))
            {
                writer.WritePropertyName("initialReplicationProgressPercentage"u8);
                writer.WriteNumberValue(InitialReplicationProgressPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProcessedBytes))
            {
                writer.WritePropertyName("initialReplicationProcessedBytes"u8);
                writer.WriteNumberValue(InitialReplicationProcessedBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationTransferredBytes))
            {
                writer.WritePropertyName("initialReplicationTransferredBytes"u8);
                writer.WriteNumberValue(InitialReplicationTransferredBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProgressHealth))
            {
                writer.WritePropertyName("initialReplicationProgressHealth"u8);
                writer.WriteStringValue(InitialReplicationProgressHealth.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProgressPercentage))
            {
                writer.WritePropertyName("resyncProgressPercentage"u8);
                writer.WriteNumberValue(ResyncProgressPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProcessedBytes))
            {
                writer.WritePropertyName("resyncProcessedBytes"u8);
                writer.WriteNumberValue(ResyncProcessedBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncTransferredBytes))
            {
                writer.WritePropertyName("resyncTransferredBytes"u8);
                writer.WriteNumberValue(ResyncTransferredBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProgressHealth))
            {
                writer.WritePropertyName("resyncProgressHealth"u8);
                writer.WriteStringValue(ResyncProgressHealth.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncRequired))
            {
                writer.WritePropertyName("resyncRequired"u8);
                writer.WriteStringValue(ResyncRequired);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncState))
            {
                writer.WritePropertyName("resyncState"u8);
                writer.WriteStringValue(ResyncState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(AgentUpgradeState))
            {
                writer.WritePropertyName("agentUpgradeState"u8);
                writer.WriteStringValue(AgentUpgradeState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LastAgentUpgradeType))
            {
                writer.WritePropertyName("lastAgentUpgradeType"u8);
                writer.WriteStringValue(LastAgentUpgradeType);
            }
            if (options.Format != "W" && Optional.IsDefined(AgentUpgradeJobId))
            {
                writer.WritePropertyName("agentUpgradeJobId"u8);
                writer.WriteStringValue(AgentUpgradeJobId);
            }
            if (options.Format != "W" && Optional.IsDefined(AgentUpgradeAttemptToVersion))
            {
                writer.WritePropertyName("agentUpgradeAttemptToVersion"u8);
                writer.WriteStringValue(AgentUpgradeAttemptToVersion);
            }
            if (Optional.IsCollectionDefined(ProtectedDisks))
            {
                writer.WritePropertyName("protectedDisks"u8);
                writer.WriteStartArray();
                foreach (var item in ProtectedDisks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(IsLastUpgradeSuccessful))
            {
                writer.WritePropertyName("isLastUpgradeSuccessful"u8);
                writer.WriteStringValue(IsLastUpgradeSuccessful);
            }
            if (options.Format != "W" && Optional.IsDefined(IsAgentRegistrationSuccessfulAfterFailover))
            {
                writer.WritePropertyName("isAgentRegistrationSuccessfulAfterFailover"u8);
                writer.WriteBooleanValue(IsAgentRegistrationSuccessfulAfterFailover.Value);
            }
            if (Optional.IsDefined(MobilityAgentDetails))
            {
                writer.WritePropertyName("mobilityAgentDetails"u8);
                writer.WriteObjectValue(MobilityAgentDetails, options);
            }
            if (Optional.IsCollectionDefined(LastAgentUpgradeErrorDetails))
            {
                writer.WritePropertyName("lastAgentUpgradeErrorDetails"u8);
                writer.WriteStartArray();
                foreach (var item in LastAgentUpgradeErrorDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AgentUpgradeBlockingErrorDetails))
            {
                writer.WritePropertyName("agentUpgradeBlockingErrorDetails"u8);
                writer.WriteStartArray();
                foreach (var item in AgentUpgradeBlockingErrorDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VmNics))
            {
                writer.WritePropertyName("vmNics"u8);
                writer.WriteStartArray();
                foreach (var item in VmNics)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DiscoveredVmDetails))
            {
                writer.WritePropertyName("discoveredVmDetails"u8);
                writer.WriteObjectValue(DiscoveredVmDetails, options);
            }
        }

        InMageRcmReplicationDetails IJsonModel<InMageRcmReplicationDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InMageRcmReplicationDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInMageRcmReplicationDetails(document.RootElement, options);
        }

        internal static InMageRcmReplicationDetails DeserializeInMageRcmReplicationDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string internalIdentifier = default;
            string fabricDiscoveryMachineId = default;
            string multiVmGroupName = default;
            string discoveryType = default;
            Guid? processServerId = default;
            int? processorCoreCount = default;
            double? allocatedMemoryInMB = default;
            string processServerName = default;
            string runAsAccountId = default;
            string osType = default;
            string firmwareType = default;
            IPAddress primaryNicIPAddress = default;
            string targetGeneration = default;
            string licenseType = default;
            ResourceIdentifier storageAccountId = default;
            string targetVmName = default;
            string targetVmSize = default;
            ResourceIdentifier targetResourceGroupId = default;
            string targetLocation = default;
            ResourceIdentifier targetAvailabilitySetId = default;
            string targetAvailabilityZone = default;
            ResourceIdentifier targetProximityPlacementGroupId = default;
            ResourceIdentifier targetBootDiagnosticsStorageAccountId = default;
            ResourceIdentifier targetNetworkId = default;
            ResourceIdentifier testNetworkId = default;
            ResourceIdentifier failoverRecoveryPointId = default;
            DateTimeOffset? lastRecoveryPointReceived = default;
            long? lastRpoInSeconds = default;
            DateTimeOffset? lastRpoCalculatedTime = default;
            ResourceIdentifier lastRecoveryPointId = default;
            int? initialReplicationProgressPercentage = default;
            long? initialReplicationProcessedBytes = default;
            long? initialReplicationTransferredBytes = default;
            VmReplicationProgressHealth? initialReplicationProgressHealth = default;
            int? resyncProgressPercentage = default;
            long? resyncProcessedBytes = default;
            long? resyncTransferredBytes = default;
            VmReplicationProgressHealth? resyncProgressHealth = default;
            string resyncRequired = default;
            SiteRecoveryResyncState? resyncState = default;
            MobilityAgentUpgradeState? agentUpgradeState = default;
            string lastAgentUpgradeType = default;
            string agentUpgradeJobId = default;
            string agentUpgradeAttemptToVersion = default;
            IReadOnlyList<InMageRcmProtectedDiskDetails> protectedDisks = default;
            string isLastUpgradeSuccessful = default;
            bool? isAgentRegistrationSuccessfulAfterFailover = default;
            InMageRcmMobilityAgentDetails mobilityAgentDetails = default;
            IReadOnlyList<InMageRcmLastAgentUpgradeErrorDetails> lastAgentUpgradeErrorDetails = default;
            IReadOnlyList<InMageRcmAgentUpgradeBlockingErrorDetails> agentUpgradeBlockingErrorDetails = default;
            IReadOnlyList<InMageRcmNicDetails> vmNics = default;
            InMageRcmDiscoveredProtectedVmDetails discoveredVmDetails = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("internalIdentifier"u8))
                {
                    internalIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fabricDiscoveryMachineId"u8))
                {
                    fabricDiscoveryMachineId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("multiVmGroupName"u8))
                {
                    multiVmGroupName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("discoveryType"u8))
                {
                    discoveryType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("processServerId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    processServerId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("processorCoreCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    processorCoreCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allocatedMemoryInMB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocatedMemoryInMB = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("processServerName"u8))
                {
                    processServerName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("runAsAccountId"u8))
                {
                    runAsAccountId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("osType"u8))
                {
                    osType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firmwareType"u8))
                {
                    firmwareType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primaryNicIpAddress"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primaryNicIPAddress = IPAddress.Parse(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetGeneration"u8))
                {
                    targetGeneration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("licenseType"u8))
                {
                    licenseType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storageAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetVmName"u8))
                {
                    targetVmName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetVmSize"u8))
                {
                    targetVmSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetResourceGroupId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetResourceGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetLocation"u8))
                {
                    targetLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetAvailabilitySetId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetAvailabilitySetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetAvailabilityZone"u8))
                {
                    targetAvailabilityZone = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetProximityPlacementGroupId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetProximityPlacementGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetBootDiagnosticsStorageAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetBootDiagnosticsStorageAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetNetworkId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetNetworkId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("testNetworkId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    testNetworkId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("failoverRecoveryPointId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failoverRecoveryPointId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastRecoveryPointReceived"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRecoveryPointReceived = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastRpoInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRpoInSeconds = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("lastRpoCalculatedTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRpoCalculatedTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastRecoveryPointId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRecoveryPointId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("initialReplicationProgressPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProgressPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("initialReplicationProcessedBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProcessedBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("initialReplicationTransferredBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationTransferredBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("initialReplicationProgressHealth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProgressHealth = new VmReplicationProgressHealth(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resyncProgressPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProgressPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("resyncProcessedBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProcessedBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("resyncTransferredBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncTransferredBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("resyncProgressHealth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProgressHealth = new VmReplicationProgressHealth(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resyncRequired"u8))
                {
                    resyncRequired = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resyncState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncState = new SiteRecoveryResyncState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("agentUpgradeState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    agentUpgradeState = new MobilityAgentUpgradeState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastAgentUpgradeType"u8))
                {
                    lastAgentUpgradeType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("agentUpgradeJobId"u8))
                {
                    agentUpgradeJobId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("agentUpgradeAttemptToVersion"u8))
                {
                    agentUpgradeAttemptToVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("protectedDisks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InMageRcmProtectedDiskDetails> array = new List<InMageRcmProtectedDiskDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InMageRcmProtectedDiskDetails.DeserializeInMageRcmProtectedDiskDetails(item, options));
                    }
                    protectedDisks = array;
                    continue;
                }
                if (property.NameEquals("isLastUpgradeSuccessful"u8))
                {
                    isLastUpgradeSuccessful = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isAgentRegistrationSuccessfulAfterFailover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAgentRegistrationSuccessfulAfterFailover = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("mobilityAgentDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mobilityAgentDetails = InMageRcmMobilityAgentDetails.DeserializeInMageRcmMobilityAgentDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("lastAgentUpgradeErrorDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InMageRcmLastAgentUpgradeErrorDetails> array = new List<InMageRcmLastAgentUpgradeErrorDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InMageRcmLastAgentUpgradeErrorDetails.DeserializeInMageRcmLastAgentUpgradeErrorDetails(item, options));
                    }
                    lastAgentUpgradeErrorDetails = array;
                    continue;
                }
                if (property.NameEquals("agentUpgradeBlockingErrorDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InMageRcmAgentUpgradeBlockingErrorDetails> array = new List<InMageRcmAgentUpgradeBlockingErrorDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InMageRcmAgentUpgradeBlockingErrorDetails.DeserializeInMageRcmAgentUpgradeBlockingErrorDetails(item, options));
                    }
                    agentUpgradeBlockingErrorDetails = array;
                    continue;
                }
                if (property.NameEquals("vmNics"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InMageRcmNicDetails> array = new List<InMageRcmNicDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InMageRcmNicDetails.DeserializeInMageRcmNicDetails(item, options));
                    }
                    vmNics = array;
                    continue;
                }
                if (property.NameEquals("discoveredVmDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    discoveredVmDetails = InMageRcmDiscoveredProtectedVmDetails.DeserializeInMageRcmDiscoveredProtectedVmDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InMageRcmReplicationDetails(
                instanceType,
                serializedAdditionalRawData,
                internalIdentifier,
                fabricDiscoveryMachineId,
                multiVmGroupName,
                discoveryType,
                processServerId,
                processorCoreCount,
                allocatedMemoryInMB,
                processServerName,
                runAsAccountId,
                osType,
                firmwareType,
                primaryNicIPAddress,
                targetGeneration,
                licenseType,
                storageAccountId,
                targetVmName,
                targetVmSize,
                targetResourceGroupId,
                targetLocation,
                targetAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                targetBootDiagnosticsStorageAccountId,
                targetNetworkId,
                testNetworkId,
                failoverRecoveryPointId,
                lastRecoveryPointReceived,
                lastRpoInSeconds,
                lastRpoCalculatedTime,
                lastRecoveryPointId,
                initialReplicationProgressPercentage,
                initialReplicationProcessedBytes,
                initialReplicationTransferredBytes,
                initialReplicationProgressHealth,
                resyncProgressPercentage,
                resyncProcessedBytes,
                resyncTransferredBytes,
                resyncProgressHealth,
                resyncRequired,
                resyncState,
                agentUpgradeState,
                lastAgentUpgradeType,
                agentUpgradeJobId,
                agentUpgradeAttemptToVersion,
                protectedDisks ?? new ChangeTrackingList<InMageRcmProtectedDiskDetails>(),
                isLastUpgradeSuccessful,
                isAgentRegistrationSuccessfulAfterFailover,
                mobilityAgentDetails,
                lastAgentUpgradeErrorDetails ?? new ChangeTrackingList<InMageRcmLastAgentUpgradeErrorDetails>(),
                agentUpgradeBlockingErrorDetails ?? new ChangeTrackingList<InMageRcmAgentUpgradeBlockingErrorDetails>(),
                vmNics ?? new ChangeTrackingList<InMageRcmNicDetails>(),
                discoveredVmDetails);
        }

        BinaryData IPersistableModel<InMageRcmReplicationDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InMageRcmReplicationDetails)} does not support writing '{options.Format}' format.");
            }
        }

        InMageRcmReplicationDetails IPersistableModel<InMageRcmReplicationDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInMageRcmReplicationDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InMageRcmReplicationDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InMageRcmReplicationDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
