// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class InMageRcmFailbackReplicationDetails : IUtf8JsonSerializable, IJsonModel<InMageRcmFailbackReplicationDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InMageRcmFailbackReplicationDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InMageRcmFailbackReplicationDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmFailbackReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InMageRcmFailbackReplicationDetails)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(InternalIdentifier))
            {
                writer.WritePropertyName("internalIdentifier"u8);
                writer.WriteStringValue(InternalIdentifier);
            }
            if (options.Format != "W" && Optional.IsDefined(AzureVirtualMachineId))
            {
                writer.WritePropertyName("azureVirtualMachineId"u8);
                writer.WriteStringValue(AzureVirtualMachineId);
            }
            if (options.Format != "W" && Optional.IsDefined(MultiVmGroupName))
            {
                writer.WritePropertyName("multiVmGroupName"u8);
                writer.WriteStringValue(MultiVmGroupName);
            }
            if (options.Format != "W" && Optional.IsDefined(ReprotectAgentId))
            {
                writer.WritePropertyName("reprotectAgentId"u8);
                writer.WriteStringValue(ReprotectAgentId);
            }
            if (options.Format != "W" && Optional.IsDefined(ReprotectAgentName))
            {
                writer.WritePropertyName("reprotectAgentName"u8);
                writer.WriteStringValue(ReprotectAgentName);
            }
            if (options.Format != "W" && Optional.IsDefined(OSType))
            {
                writer.WritePropertyName("osType"u8);
                writer.WriteStringValue(OSType);
            }
            if (options.Format != "W" && Optional.IsDefined(LogStorageAccountId))
            {
                writer.WritePropertyName("logStorageAccountId"u8);
                writer.WriteStringValue(LogStorageAccountId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetVCenterId))
            {
                writer.WritePropertyName("targetvCenterId"u8);
                writer.WriteStringValue(TargetVCenterId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetDataStoreName))
            {
                writer.WritePropertyName("targetDataStoreName"u8);
                writer.WriteStringValue(TargetDataStoreName);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetVmName))
            {
                writer.WritePropertyName("targetVmName"u8);
                writer.WriteStringValue(TargetVmName);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProgressPercentage))
            {
                writer.WritePropertyName("initialReplicationProgressPercentage"u8);
                writer.WriteNumberValue(InitialReplicationProgressPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProcessedBytes))
            {
                writer.WritePropertyName("initialReplicationProcessedBytes"u8);
                writer.WriteNumberValue(InitialReplicationProcessedBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationTransferredBytes))
            {
                writer.WritePropertyName("initialReplicationTransferredBytes"u8);
                writer.WriteNumberValue(InitialReplicationTransferredBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProgressHealth))
            {
                writer.WritePropertyName("initialReplicationProgressHealth"u8);
                writer.WriteStringValue(InitialReplicationProgressHealth.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProgressPercentage))
            {
                writer.WritePropertyName("resyncProgressPercentage"u8);
                writer.WriteNumberValue(ResyncProgressPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProcessedBytes))
            {
                writer.WritePropertyName("resyncProcessedBytes"u8);
                writer.WriteNumberValue(ResyncProcessedBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncTransferredBytes))
            {
                writer.WritePropertyName("resyncTransferredBytes"u8);
                writer.WriteNumberValue(ResyncTransferredBytes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProgressHealth))
            {
                writer.WritePropertyName("resyncProgressHealth"u8);
                writer.WriteStringValue(ResyncProgressHealth.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncRequired))
            {
                writer.WritePropertyName("resyncRequired"u8);
                writer.WriteStringValue(ResyncRequired);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncState))
            {
                writer.WritePropertyName("resyncState"u8);
                writer.WriteStringValue(ResyncState.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ProtectedDisks))
            {
                writer.WritePropertyName("protectedDisks"u8);
                writer.WriteStartArray();
                foreach (var item in ProtectedDisks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(MobilityAgentDetails))
            {
                writer.WritePropertyName("mobilityAgentDetails"u8);
                writer.WriteObjectValue(MobilityAgentDetails, options);
            }
            if (Optional.IsCollectionDefined(VmNics))
            {
                writer.WritePropertyName("vmNics"u8);
                writer.WriteStartArray();
                foreach (var item in VmNics)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(LastPlannedFailoverStartOn))
            {
                writer.WritePropertyName("lastPlannedFailoverStartTime"u8);
                writer.WriteStringValue(LastPlannedFailoverStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastPlannedFailoverStatus))
            {
                writer.WritePropertyName("lastPlannedFailoverStatus"u8);
                writer.WriteStringValue(LastPlannedFailoverStatus.Value.ToString());
            }
            if (Optional.IsDefined(DiscoveredVmDetails))
            {
                writer.WritePropertyName("discoveredVmDetails"u8);
                writer.WriteObjectValue(DiscoveredVmDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(LastUsedPolicyId))
            {
                writer.WritePropertyName("lastUsedPolicyId"u8);
                writer.WriteStringValue(LastUsedPolicyId);
            }
            if (options.Format != "W" && Optional.IsDefined(LastUsedPolicyFriendlyName))
            {
                writer.WritePropertyName("lastUsedPolicyFriendlyName"u8);
                writer.WriteStringValue(LastUsedPolicyFriendlyName);
            }
            if (options.Format != "W" && Optional.IsDefined(IsAgentRegistrationSuccessfulAfterFailover))
            {
                writer.WritePropertyName("isAgentRegistrationSuccessfulAfterFailover"u8);
                writer.WriteBooleanValue(IsAgentRegistrationSuccessfulAfterFailover.Value);
            }
        }

        InMageRcmFailbackReplicationDetails IJsonModel<InMageRcmFailbackReplicationDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmFailbackReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InMageRcmFailbackReplicationDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInMageRcmFailbackReplicationDetails(document.RootElement, options);
        }

        internal static InMageRcmFailbackReplicationDetails DeserializeInMageRcmFailbackReplicationDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string internalIdentifier = default;
            ResourceIdentifier azureVirtualMachineId = default;
            string multiVmGroupName = default;
            string reprotectAgentId = default;
            string reprotectAgentName = default;
            string osType = default;
            ResourceIdentifier logStorageAccountId = default;
            string targetvCenterId = default;
            string targetDataStoreName = default;
            string targetVmName = default;
            int? initialReplicationProgressPercentage = default;
            long? initialReplicationProcessedBytes = default;
            long? initialReplicationTransferredBytes = default;
            VmReplicationProgressHealth? initialReplicationProgressHealth = default;
            int? resyncProgressPercentage = default;
            long? resyncProcessedBytes = default;
            long? resyncTransferredBytes = default;
            VmReplicationProgressHealth? resyncProgressHealth = default;
            string resyncRequired = default;
            SiteRecoveryResyncState? resyncState = default;
            IReadOnlyList<InMageRcmFailbackProtectedDiskDetails> protectedDisks = default;
            InMageRcmFailbackMobilityAgentDetails mobilityAgentDetails = default;
            IReadOnlyList<InMageRcmFailbackNicDetails> vmNics = default;
            DateTimeOffset? lastPlannedFailoverStartTime = default;
            PlannedFailoverStatus? lastPlannedFailoverStatus = default;
            InMageRcmFailbackDiscoveredProtectedVmDetails discoveredVmDetails = default;
            ResourceIdentifier lastUsedPolicyId = default;
            string lastUsedPolicyFriendlyName = default;
            bool? isAgentRegistrationSuccessfulAfterFailover = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("internalIdentifier"u8))
                {
                    internalIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("azureVirtualMachineId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    azureVirtualMachineId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("multiVmGroupName"u8))
                {
                    multiVmGroupName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("reprotectAgentId"u8))
                {
                    reprotectAgentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("reprotectAgentName"u8))
                {
                    reprotectAgentName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("osType"u8))
                {
                    osType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("logStorageAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    logStorageAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetvCenterId"u8))
                {
                    targetvCenterId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetDataStoreName"u8))
                {
                    targetDataStoreName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetVmName"u8))
                {
                    targetVmName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("initialReplicationProgressPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProgressPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("initialReplicationProcessedBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProcessedBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("initialReplicationTransferredBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationTransferredBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("initialReplicationProgressHealth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProgressHealth = new VmReplicationProgressHealth(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resyncProgressPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProgressPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("resyncProcessedBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProcessedBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("resyncTransferredBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncTransferredBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("resyncProgressHealth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProgressHealth = new VmReplicationProgressHealth(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resyncRequired"u8))
                {
                    resyncRequired = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resyncState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncState = new SiteRecoveryResyncState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("protectedDisks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InMageRcmFailbackProtectedDiskDetails> array = new List<InMageRcmFailbackProtectedDiskDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InMageRcmFailbackProtectedDiskDetails.DeserializeInMageRcmFailbackProtectedDiskDetails(item, options));
                    }
                    protectedDisks = array;
                    continue;
                }
                if (property.NameEquals("mobilityAgentDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mobilityAgentDetails = InMageRcmFailbackMobilityAgentDetails.DeserializeInMageRcmFailbackMobilityAgentDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("vmNics"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InMageRcmFailbackNicDetails> array = new List<InMageRcmFailbackNicDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InMageRcmFailbackNicDetails.DeserializeInMageRcmFailbackNicDetails(item, options));
                    }
                    vmNics = array;
                    continue;
                }
                if (property.NameEquals("lastPlannedFailoverStartTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastPlannedFailoverStartTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastPlannedFailoverStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastPlannedFailoverStatus = new PlannedFailoverStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("discoveredVmDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    discoveredVmDetails = InMageRcmFailbackDiscoveredProtectedVmDetails.DeserializeInMageRcmFailbackDiscoveredProtectedVmDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("lastUsedPolicyId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastUsedPolicyId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastUsedPolicyFriendlyName"u8))
                {
                    lastUsedPolicyFriendlyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isAgentRegistrationSuccessfulAfterFailover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAgentRegistrationSuccessfulAfterFailover = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InMageRcmFailbackReplicationDetails(
                instanceType,
                serializedAdditionalRawData,
                internalIdentifier,
                azureVirtualMachineId,
                multiVmGroupName,
                reprotectAgentId,
                reprotectAgentName,
                osType,
                logStorageAccountId,
                targetvCenterId,
                targetDataStoreName,
                targetVmName,
                initialReplicationProgressPercentage,
                initialReplicationProcessedBytes,
                initialReplicationTransferredBytes,
                initialReplicationProgressHealth,
                resyncProgressPercentage,
                resyncProcessedBytes,
                resyncTransferredBytes,
                resyncProgressHealth,
                resyncRequired,
                resyncState,
                protectedDisks ?? new ChangeTrackingList<InMageRcmFailbackProtectedDiskDetails>(),
                mobilityAgentDetails,
                vmNics ?? new ChangeTrackingList<InMageRcmFailbackNicDetails>(),
                lastPlannedFailoverStartTime,
                lastPlannedFailoverStatus,
                discoveredVmDetails,
                lastUsedPolicyId,
                lastUsedPolicyFriendlyName,
                isAgentRegistrationSuccessfulAfterFailover);
        }

        BinaryData IPersistableModel<InMageRcmFailbackReplicationDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmFailbackReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InMageRcmFailbackReplicationDetails)} does not support writing '{options.Format}' format.");
            }
        }

        InMageRcmFailbackReplicationDetails IPersistableModel<InMageRcmFailbackReplicationDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InMageRcmFailbackReplicationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInMageRcmFailbackReplicationDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InMageRcmFailbackReplicationDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InMageRcmFailbackReplicationDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
