// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. </summary>
    public readonly partial struct InMageRcmFailbackRecoveryPointType : IEquatable<InMageRcmFailbackRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InMageRcmFailbackRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InMageRcmFailbackRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplicationConsistentValue = "ApplicationConsistent";
        private const string CrashConsistentValue = "CrashConsistent";

        /// <summary> ApplicationConsistent. </summary>
        public static InMageRcmFailbackRecoveryPointType ApplicationConsistent { get; } = new InMageRcmFailbackRecoveryPointType(ApplicationConsistentValue);
        /// <summary> CrashConsistent. </summary>
        public static InMageRcmFailbackRecoveryPointType CrashConsistent { get; } = new InMageRcmFailbackRecoveryPointType(CrashConsistentValue);
        /// <summary> Determines if two <see cref="InMageRcmFailbackRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(InMageRcmFailbackRecoveryPointType left, InMageRcmFailbackRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InMageRcmFailbackRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(InMageRcmFailbackRecoveryPointType left, InMageRcmFailbackRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InMageRcmFailbackRecoveryPointType"/>. </summary>
        public static implicit operator InMageRcmFailbackRecoveryPointType(string value) => new InMageRcmFailbackRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InMageRcmFailbackRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InMageRcmFailbackRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
