// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageRcm fabric specific details. </summary>
    public partial class InMageRcmFabricSpecificDetails : FabricSpecificDetails
    {
        /// <summary> Initializes a new instance of <see cref="InMageRcmFabricSpecificDetails"/>. </summary>
        internal InMageRcmFabricSpecificDetails()
        {
            ProcessServers = new ChangeTrackingList<SiteRecoveryProcessServerDetails>();
            RcmProxies = new ChangeTrackingList<RcmProxyDetails>();
            PushInstallers = new ChangeTrackingList<PushInstallerDetails>();
            ReplicationAgents = new ChangeTrackingList<ReplicationAgentDetails>();
            ReprotectAgents = new ChangeTrackingList<ReprotectAgentDetails>();
            MarsAgents = new ChangeTrackingList<MarsAgentDetails>();
            Dras = new ChangeTrackingList<SiteRecoveryDraDetails>();
            AgentDetails = new ChangeTrackingList<SiteRecoveryAgentDetails>();
            InstanceType = "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmFabricSpecificDetails"/>. </summary>
        /// <param name="instanceType"> Gets the class type. Overridden in derived classes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="serviceEndpoint"> The service endpoint. </param>
        /// <param name="serviceResourceId"> The service resource Id. </param>
        /// <param name="serviceContainerId"> The service container Id. </param>
        /// <param name="dataPlaneUri"> The data plane Uri. </param>
        /// <param name="controlPlaneUri"> The control plane Uri. </param>
        /// <param name="sourceAgentIdentityDetails"> The source agent identity details. </param>
        /// <param name="processServers"> The list of process servers. </param>
        /// <param name="rcmProxies"> The list of RCM proxies. </param>
        /// <param name="pushInstallers"> The list of push installers. </param>
        /// <param name="replicationAgents"> The list of replication agents. </param>
        /// <param name="reprotectAgents"> The list of reprotect agents. </param>
        /// <param name="marsAgents"> The list of Mars agents. </param>
        /// <param name="dras"> The list of DRAs. </param>
        /// <param name="agentDetails"> The list of agent details. </param>
        internal InMageRcmFabricSpecificDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier vmwareSiteId, ResourceIdentifier physicalSiteId, string serviceEndpoint, ResourceIdentifier serviceResourceId, string serviceContainerId, Uri dataPlaneUri, Uri controlPlaneUri, IdentityProviderDetails sourceAgentIdentityDetails, IReadOnlyList<SiteRecoveryProcessServerDetails> processServers, IReadOnlyList<RcmProxyDetails> rcmProxies, IReadOnlyList<PushInstallerDetails> pushInstallers, IReadOnlyList<ReplicationAgentDetails> replicationAgents, IReadOnlyList<ReprotectAgentDetails> reprotectAgents, IReadOnlyList<MarsAgentDetails> marsAgents, IReadOnlyList<SiteRecoveryDraDetails> dras, IReadOnlyList<SiteRecoveryAgentDetails> agentDetails) : base(instanceType, serializedAdditionalRawData)
        {
            VMwareSiteId = vmwareSiteId;
            PhysicalSiteId = physicalSiteId;
            ServiceEndpoint = serviceEndpoint;
            ServiceResourceId = serviceResourceId;
            ServiceContainerId = serviceContainerId;
            DataPlaneUri = dataPlaneUri;
            ControlPlaneUri = controlPlaneUri;
            SourceAgentIdentityDetails = sourceAgentIdentityDetails;
            ProcessServers = processServers;
            RcmProxies = rcmProxies;
            PushInstallers = pushInstallers;
            ReplicationAgents = replicationAgents;
            ReprotectAgents = reprotectAgents;
            MarsAgents = marsAgents;
            Dras = dras;
            AgentDetails = agentDetails;
            InstanceType = instanceType ?? "InMageRcm";
        }

        /// <summary> The ARM Id of the VMware site. </summary>
        public ResourceIdentifier VMwareSiteId { get; }
        /// <summary> The ARM Id of the physical site. </summary>
        public ResourceIdentifier PhysicalSiteId { get; }
        /// <summary> The service endpoint. </summary>
        public string ServiceEndpoint { get; }
        /// <summary> The service resource Id. </summary>
        public ResourceIdentifier ServiceResourceId { get; }
        /// <summary> The service container Id. </summary>
        public string ServiceContainerId { get; }
        /// <summary> The data plane Uri. </summary>
        public Uri DataPlaneUri { get; }
        /// <summary> The control plane Uri. </summary>
        public Uri ControlPlaneUri { get; }
        /// <summary> The source agent identity details. </summary>
        public IdentityProviderDetails SourceAgentIdentityDetails { get; }
        /// <summary> The list of process servers. </summary>
        public IReadOnlyList<SiteRecoveryProcessServerDetails> ProcessServers { get; }
        /// <summary> The list of RCM proxies. </summary>
        public IReadOnlyList<RcmProxyDetails> RcmProxies { get; }
        /// <summary> The list of push installers. </summary>
        public IReadOnlyList<PushInstallerDetails> PushInstallers { get; }
        /// <summary> The list of replication agents. </summary>
        public IReadOnlyList<ReplicationAgentDetails> ReplicationAgents { get; }
        /// <summary> The list of reprotect agents. </summary>
        public IReadOnlyList<ReprotectAgentDetails> ReprotectAgents { get; }
        /// <summary> The list of Mars agents. </summary>
        public IReadOnlyList<MarsAgentDetails> MarsAgents { get; }
        /// <summary> The list of DRAs. </summary>
        public IReadOnlyList<SiteRecoveryDraDetails> Dras { get; }
        /// <summary> The list of agent details. </summary>
        public IReadOnlyList<SiteRecoveryAgentDetails> AgentDetails { get; }
    }
}
