// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageRcm fabric provider specific settings. </summary>
    public partial class InMageRcmFabricCreationContent : FabricSpecificCreationContent
    {
        /// <summary> Initializes a new instance of <see cref="InMageRcmFabricCreationContent"/>. </summary>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="sourceAgentIdentity"> The identity provider input for source agent authentication. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vmwareSiteId"/>, <paramref name="physicalSiteId"/> or <paramref name="sourceAgentIdentity"/> is null. </exception>
        public InMageRcmFabricCreationContent(ResourceIdentifier vmwareSiteId, ResourceIdentifier physicalSiteId, IdentityProviderContent sourceAgentIdentity)
        {
            Argument.AssertNotNull(vmwareSiteId, nameof(vmwareSiteId));
            Argument.AssertNotNull(physicalSiteId, nameof(physicalSiteId));
            Argument.AssertNotNull(sourceAgentIdentity, nameof(sourceAgentIdentity));

            VMwareSiteId = vmwareSiteId;
            PhysicalSiteId = physicalSiteId;
            SourceAgentIdentity = sourceAgentIdentity;
            InstanceType = "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmFabricCreationContent"/>. </summary>
        /// <param name="instanceType"> Gets the class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="sourceAgentIdentity"> The identity provider input for source agent authentication. </param>
        internal InMageRcmFabricCreationContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier vmwareSiteId, ResourceIdentifier physicalSiteId, IdentityProviderContent sourceAgentIdentity) : base(instanceType, serializedAdditionalRawData)
        {
            VMwareSiteId = vmwareSiteId;
            PhysicalSiteId = physicalSiteId;
            SourceAgentIdentity = sourceAgentIdentity;
            InstanceType = instanceType ?? "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmFabricCreationContent"/> for deserialization. </summary>
        internal InMageRcmFabricCreationContent()
        {
        }

        /// <summary> The ARM Id of the VMware site. </summary>
        public ResourceIdentifier VMwareSiteId { get; }
        /// <summary> The ARM Id of the physical site. </summary>
        public ResourceIdentifier PhysicalSiteId { get; }
        /// <summary> The identity provider input for source agent authentication. </summary>
        public IdentityProviderContent SourceAgentIdentity { get; }
    }
}
