// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageRcm specific enable protection input. </summary>
    public partial class InMageRcmEnableProtectionContent : EnableProtectionProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="InMageRcmEnableProtectionContent"/>. </summary>
        /// <param name="fabricDiscoveryMachineId"> The ARM Id of discovered machine. </param>
        /// <param name="targetResourceGroupId"> The target resource group ARM Id. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricDiscoveryMachineId"/> or <paramref name="targetResourceGroupId"/> is null. </exception>
        public InMageRcmEnableProtectionContent(string fabricDiscoveryMachineId, ResourceIdentifier targetResourceGroupId, Guid processServerId)
        {
            Argument.AssertNotNull(fabricDiscoveryMachineId, nameof(fabricDiscoveryMachineId));
            Argument.AssertNotNull(targetResourceGroupId, nameof(targetResourceGroupId));

            FabricDiscoveryMachineId = fabricDiscoveryMachineId;
            DisksToInclude = new ChangeTrackingList<InMageRcmDiskContent>();
            TargetResourceGroupId = targetResourceGroupId;
            ProcessServerId = processServerId;
            InstanceType = "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmEnableProtectionContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="fabricDiscoveryMachineId"> The ARM Id of discovered machine. </param>
        /// <param name="disksToInclude"> The disks to include list. </param>
        /// <param name="disksDefault"> The default disk input. </param>
        /// <param name="targetResourceGroupId"> The target resource group ARM Id. </param>
        /// <param name="targetNetworkId"> The selected target network ARM Id. </param>
        /// <param name="testNetworkId"> The selected test network ARM Id. </param>
        /// <param name="targetSubnetName"> The selected target subnet name. </param>
        /// <param name="testSubnetName"> The selected test subnet name. </param>
        /// <param name="targetVmName"> The target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="licenseType"> The license type. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set ARM Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="runAsAccountId"> The run-as account Id. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="multiVmGroupName"> The multi VM group name. </param>
        internal InMageRcmEnableProtectionContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string fabricDiscoveryMachineId, IList<InMageRcmDiskContent> disksToInclude, InMageRcmDisksDefaultContent disksDefault, ResourceIdentifier targetResourceGroupId, ResourceIdentifier targetNetworkId, ResourceIdentifier testNetworkId, string targetSubnetName, string testSubnetName, string targetVmName, string targetVmSize, SiteRecoveryLicenseType? licenseType, ResourceIdentifier targetAvailabilitySetId, string targetAvailabilityZone, ResourceIdentifier targetProximityPlacementGroupId, ResourceIdentifier targetBootDiagnosticsStorageAccountId, string runAsAccountId, Guid processServerId, string multiVmGroupName) : base(instanceType, serializedAdditionalRawData)
        {
            FabricDiscoveryMachineId = fabricDiscoveryMachineId;
            DisksToInclude = disksToInclude;
            DisksDefault = disksDefault;
            TargetResourceGroupId = targetResourceGroupId;
            TargetNetworkId = targetNetworkId;
            TestNetworkId = testNetworkId;
            TargetSubnetName = targetSubnetName;
            TestSubnetName = testSubnetName;
            TargetVmName = targetVmName;
            TargetVmSize = targetVmSize;
            LicenseType = licenseType;
            TargetAvailabilitySetId = targetAvailabilitySetId;
            TargetAvailabilityZone = targetAvailabilityZone;
            TargetProximityPlacementGroupId = targetProximityPlacementGroupId;
            TargetBootDiagnosticsStorageAccountId = targetBootDiagnosticsStorageAccountId;
            RunAsAccountId = runAsAccountId;
            ProcessServerId = processServerId;
            MultiVmGroupName = multiVmGroupName;
            InstanceType = instanceType ?? "InMageRcm";
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmEnableProtectionContent"/> for deserialization. </summary>
        internal InMageRcmEnableProtectionContent()
        {
        }

        /// <summary> The ARM Id of discovered machine. </summary>
        public string FabricDiscoveryMachineId { get; }
        /// <summary> The disks to include list. </summary>
        public IList<InMageRcmDiskContent> DisksToInclude { get; }
        /// <summary> The default disk input. </summary>
        public InMageRcmDisksDefaultContent DisksDefault { get; set; }
        /// <summary> The target resource group ARM Id. </summary>
        public ResourceIdentifier TargetResourceGroupId { get; }
        /// <summary> The selected target network ARM Id. </summary>
        public ResourceIdentifier TargetNetworkId { get; set; }
        /// <summary> The selected test network ARM Id. </summary>
        public ResourceIdentifier TestNetworkId { get; set; }
        /// <summary> The selected target subnet name. </summary>
        public string TargetSubnetName { get; set; }
        /// <summary> The selected test subnet name. </summary>
        public string TestSubnetName { get; set; }
        /// <summary> The target VM name. </summary>
        public string TargetVmName { get; set; }
        /// <summary> The target VM size. </summary>
        public string TargetVmSize { get; set; }
        /// <summary> The license type. </summary>
        public SiteRecoveryLicenseType? LicenseType { get; set; }
        /// <summary> The target availability set ARM Id. </summary>
        public ResourceIdentifier TargetAvailabilitySetId { get; set; }
        /// <summary> The target availability zone. </summary>
        public string TargetAvailabilityZone { get; set; }
        /// <summary> The target proximity placement group Id. </summary>
        public ResourceIdentifier TargetProximityPlacementGroupId { get; set; }
        /// <summary> The target boot diagnostics storage account ARM Id. </summary>
        public ResourceIdentifier TargetBootDiagnosticsStorageAccountId { get; set; }
        /// <summary> The run-as account Id. </summary>
        public string RunAsAccountId { get; set; }
        /// <summary> The process server Id. </summary>
        public Guid ProcessServerId { get; }
        /// <summary> The multi VM group name. </summary>
        public string MultiVmGroupName { get; set; }
    }
}
