// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageRcm appliance details. </summary>
    public partial class InMageRcmApplianceDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InMageRcmApplianceDetails"/>. </summary>
        internal InMageRcmApplianceDetails()
        {
            SwitchProviderBlockingErrorDetails = new ChangeTrackingList<InMageRcmFabricSwitchProviderBlockingErrorDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="InMageRcmApplianceDetails"/>. </summary>
        /// <param name="id"> The appliance Id. </param>
        /// <param name="name"> The appliance name. </param>
        /// <param name="fabricArmId"> The fabric ARM Id. </param>
        /// <param name="processServer"> The process server. </param>
        /// <param name="rcmProxy"> The of RCM proxy. </param>
        /// <param name="pushInstaller"> The push installer. </param>
        /// <param name="replicationAgent"> The replication agent. </param>
        /// <param name="reprotectAgent"> The reprotect agent. </param>
        /// <param name="marsAgent"> The Mars agent. </param>
        /// <param name="dra"> The DRA. </param>
        /// <param name="switchProviderBlockingErrorDetails"> The switch provider blocking error information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InMageRcmApplianceDetails(string id, string name, ResourceIdentifier fabricArmId, SiteRecoveryProcessServerDetails processServer, RcmProxyDetails rcmProxy, PushInstallerDetails pushInstaller, ReplicationAgentDetails replicationAgent, ReprotectAgentDetails reprotectAgent, MarsAgentDetails marsAgent, SiteRecoveryDraDetails dra, IReadOnlyList<InMageRcmFabricSwitchProviderBlockingErrorDetails> switchProviderBlockingErrorDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            FabricArmId = fabricArmId;
            ProcessServer = processServer;
            RcmProxy = rcmProxy;
            PushInstaller = pushInstaller;
            ReplicationAgent = replicationAgent;
            ReprotectAgent = reprotectAgent;
            MarsAgent = marsAgent;
            Dra = dra;
            SwitchProviderBlockingErrorDetails = switchProviderBlockingErrorDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The appliance Id. </summary>
        public string Id { get; }
        /// <summary> The appliance name. </summary>
        public string Name { get; }
        /// <summary> The fabric ARM Id. </summary>
        public ResourceIdentifier FabricArmId { get; }
        /// <summary> The process server. </summary>
        public SiteRecoveryProcessServerDetails ProcessServer { get; }
        /// <summary> The of RCM proxy. </summary>
        public RcmProxyDetails RcmProxy { get; }
        /// <summary> The push installer. </summary>
        public PushInstallerDetails PushInstaller { get; }
        /// <summary> The replication agent. </summary>
        public ReplicationAgentDetails ReplicationAgent { get; }
        /// <summary> The reprotect agent. </summary>
        public ReprotectAgentDetails ReprotectAgent { get; }
        /// <summary> The Mars agent. </summary>
        public MarsAgentDetails MarsAgent { get; }
        /// <summary> The DRA. </summary>
        public SiteRecoveryDraDetails Dra { get; }
        /// <summary> The switch provider blocking error information. </summary>
        public IReadOnlyList<InMageRcmFabricSwitchProviderBlockingErrorDetails> SwitchProviderBlockingErrorDetails { get; }
    }
}
