// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMage Azure V2 input to update replication protected item. </summary>
    public partial class InMageAzureV2UpdateReplicationProtectedItemContent : UpdateReplicationProtectedItemProviderContent
    {
        /// <summary> Initializes a new instance of <see cref="InMageAzureV2UpdateReplicationProtectedItemContent"/>. </summary>
        public InMageAzureV2UpdateReplicationProtectedItemContent()
        {
            TargetVmTags = new ChangeTrackingDictionary<string, string>();
            TargetManagedDiskTags = new ChangeTrackingDictionary<string, string>();
            TargetNicTags = new ChangeTrackingDictionary<string, string>();
            VmDisks = new ChangeTrackingList<UpdateDiskContent>();
            InstanceType = "InMageAzureV2";
        }

        /// <summary> Initializes a new instance of <see cref="InMageAzureV2UpdateReplicationProtectedItemContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryAzureV1ResourceGroupId"> The recovery Azure resource group Id for classic deployment. </param>
        /// <param name="recoveryAzureV2ResourceGroupId"> The recovery Azure resource group Id for resource manager deployment. </param>
        /// <param name="useManagedDisks"> A value indicating whether managed disks should be used during failover. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetVmTags"> The target VM tags. </param>
        /// <param name="targetManagedDiskTags"> The tags for the target managed disks. </param>
        /// <param name="targetNicTags"> The tags for the target NICs. </param>
        /// <param name="sqlServerLicenseType"> The SQL Server license type. </param>
        /// <param name="vmDisks"> The list of disk update properties. </param>
        internal InMageAzureV2UpdateReplicationProtectedItemContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier recoveryAzureV1ResourceGroupId, ResourceIdentifier recoveryAzureV2ResourceGroupId, string useManagedDisks, ResourceIdentifier targetProximityPlacementGroupId, string targetAvailabilityZone, IDictionary<string, string> targetVmTags, IDictionary<string, string> targetManagedDiskTags, IDictionary<string, string> targetNicTags, SiteRecoverySqlServerLicenseType? sqlServerLicenseType, IList<UpdateDiskContent> vmDisks) : base(instanceType, serializedAdditionalRawData)
        {
            RecoveryAzureV1ResourceGroupId = recoveryAzureV1ResourceGroupId;
            RecoveryAzureV2ResourceGroupId = recoveryAzureV2ResourceGroupId;
            UseManagedDisks = useManagedDisks;
            TargetProximityPlacementGroupId = targetProximityPlacementGroupId;
            TargetAvailabilityZone = targetAvailabilityZone;
            TargetVmTags = targetVmTags;
            TargetManagedDiskTags = targetManagedDiskTags;
            TargetNicTags = targetNicTags;
            SqlServerLicenseType = sqlServerLicenseType;
            VmDisks = vmDisks;
            InstanceType = instanceType ?? "InMageAzureV2";
        }

        /// <summary> The recovery Azure resource group Id for classic deployment. </summary>
        public ResourceIdentifier RecoveryAzureV1ResourceGroupId { get; set; }
        /// <summary> The recovery Azure resource group Id for resource manager deployment. </summary>
        public ResourceIdentifier RecoveryAzureV2ResourceGroupId { get; set; }
        /// <summary> A value indicating whether managed disks should be used during failover. </summary>
        public string UseManagedDisks { get; set; }
        /// <summary> The target proximity placement group Id. </summary>
        public ResourceIdentifier TargetProximityPlacementGroupId { get; set; }
        /// <summary> The target availability zone. </summary>
        public string TargetAvailabilityZone { get; set; }
        /// <summary> The target VM tags. </summary>
        public IDictionary<string, string> TargetVmTags { get; }
        /// <summary> The tags for the target managed disks. </summary>
        public IDictionary<string, string> TargetManagedDiskTags { get; }
        /// <summary> The tags for the target NICs. </summary>
        public IDictionary<string, string> TargetNicTags { get; }
        /// <summary> The SQL Server license type. </summary>
        public SiteRecoverySqlServerLicenseType? SqlServerLicenseType { get; set; }
        /// <summary> The list of disk update properties. </summary>
        public IList<UpdateDiskContent> VmDisks { get; }
    }
}
