// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> InMageAzureV2 switch provider details. </summary>
    public partial class InMageAzureV2SwitchProviderDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InMageAzureV2SwitchProviderDetails"/>. </summary>
        internal InMageAzureV2SwitchProviderDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InMageAzureV2SwitchProviderDetails"/>. </summary>
        /// <param name="targetVaultId"> The target vault Id. </param>
        /// <param name="targetResourceId"> The target resource Id. </param>
        /// <param name="targetFabricId"> The target fabric Id. </param>
        /// <param name="targetApplianceId"> The target appliance Id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InMageAzureV2SwitchProviderDetails(ResourceIdentifier targetVaultId, ResourceIdentifier targetResourceId, ResourceIdentifier targetFabricId, string targetApplianceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetVaultId = targetVaultId;
            TargetResourceId = targetResourceId;
            TargetFabricId = targetFabricId;
            TargetApplianceId = targetApplianceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The target vault Id. </summary>
        public ResourceIdentifier TargetVaultId { get; }
        /// <summary> The target resource Id. </summary>
        public ResourceIdentifier TargetResourceId { get; }
        /// <summary> The target fabric Id. </summary>
        public ResourceIdentifier TargetFabricId { get; }
        /// <summary> The target appliance Id. </summary>
        public string TargetApplianceId { get; }
    }
}
