// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Provider specific input for InMageAzureV2 switch provider. </summary>
    public partial class InMageAzureV2SwitchProviderContent : SwitchProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="InMageAzureV2SwitchProviderContent"/>. </summary>
        /// <param name="targetVaultId"> The target vault Id. </param>
        /// <param name="targetFabricId"> The target fabric Id. </param>
        /// <param name="targetApplianceId"> The target appliance Id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetVaultId"/>, <paramref name="targetFabricId"/> or <paramref name="targetApplianceId"/> is null. </exception>
        public InMageAzureV2SwitchProviderContent(ResourceIdentifier targetVaultId, ResourceIdentifier targetFabricId, string targetApplianceId)
        {
            Argument.AssertNotNull(targetVaultId, nameof(targetVaultId));
            Argument.AssertNotNull(targetFabricId, nameof(targetFabricId));
            Argument.AssertNotNull(targetApplianceId, nameof(targetApplianceId));

            TargetVaultId = targetVaultId;
            TargetFabricId = targetFabricId;
            TargetApplianceId = targetApplianceId;
            InstanceType = "InMageAzureV2";
        }

        /// <summary> Initializes a new instance of <see cref="InMageAzureV2SwitchProviderContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="targetVaultId"> The target vault Id. </param>
        /// <param name="targetFabricId"> The target fabric Id. </param>
        /// <param name="targetApplianceId"> The target appliance Id. </param>
        internal InMageAzureV2SwitchProviderContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier targetVaultId, ResourceIdentifier targetFabricId, string targetApplianceId) : base(instanceType, serializedAdditionalRawData)
        {
            TargetVaultId = targetVaultId;
            TargetFabricId = targetFabricId;
            TargetApplianceId = targetApplianceId;
            InstanceType = instanceType ?? "InMageAzureV2";
        }

        /// <summary> Initializes a new instance of <see cref="InMageAzureV2SwitchProviderContent"/> for deserialization. </summary>
        internal InMageAzureV2SwitchProviderContent()
        {
        }

        /// <summary> The target vault Id. </summary>
        public ResourceIdentifier TargetVaultId { get; }
        /// <summary> The target fabric Id. </summary>
        public ResourceIdentifier TargetFabricId { get; }
        /// <summary> The target appliance Id. </summary>
        public string TargetApplianceId { get; }
    }
}
