// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum. </summary>
    public readonly partial struct HyperVVmDiskPresenceStatus : IEquatable<HyperVVmDiskPresenceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HyperVVmDiskPresenceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HyperVVmDiskPresenceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PresentValue = "Present";
        private const string NotPresentValue = "NotPresent";

        /// <summary> Unknown. </summary>
        public static HyperVVmDiskPresenceStatus Unknown { get; } = new HyperVVmDiskPresenceStatus(UnknownValue);
        /// <summary> Present. </summary>
        public static HyperVVmDiskPresenceStatus Present { get; } = new HyperVVmDiskPresenceStatus(PresentValue);
        /// <summary> NotPresent. </summary>
        public static HyperVVmDiskPresenceStatus NotPresent { get; } = new HyperVVmDiskPresenceStatus(NotPresentValue);
        /// <summary> Determines if two <see cref="HyperVVmDiskPresenceStatus"/> values are the same. </summary>
        public static bool operator ==(HyperVVmDiskPresenceStatus left, HyperVVmDiskPresenceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HyperVVmDiskPresenceStatus"/> values are not the same. </summary>
        public static bool operator !=(HyperVVmDiskPresenceStatus left, HyperVVmDiskPresenceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HyperVVmDiskPresenceStatus"/>. </summary>
        public static implicit operator HyperVVmDiskPresenceStatus(string value) => new HyperVVmDiskPresenceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HyperVVmDiskPresenceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HyperVVmDiskPresenceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
