// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class HyperVVmDetails : IUtf8JsonSerializable, IJsonModel<HyperVVmDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HyperVVmDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HyperVVmDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVVmDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVVmDetails)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(SourceItemId))
            {
                writer.WritePropertyName("sourceItemId"u8);
                writer.WriteStringValue(SourceItemId);
            }
            if (Optional.IsDefined(Generation))
            {
                writer.WritePropertyName("generation"u8);
                writer.WriteStringValue(Generation);
            }
            if (Optional.IsDefined(OSDetails))
            {
                writer.WritePropertyName("osDetails"u8);
                writer.WriteObjectValue(OSDetails, options);
            }
            if (Optional.IsCollectionDefined(DiskDetails))
            {
                writer.WritePropertyName("diskDetails"u8);
                writer.WriteStartArray();
                foreach (var item in DiskDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HasPhysicalDisk))
            {
                writer.WritePropertyName("hasPhysicalDisk"u8);
                writer.WriteStringValue(HasPhysicalDisk.Value.ToString());
            }
            if (Optional.IsDefined(HasFibreChannelAdapter))
            {
                writer.WritePropertyName("hasFibreChannelAdapter"u8);
                writer.WriteStringValue(HasFibreChannelAdapter.Value.ToString());
            }
            if (Optional.IsDefined(HasSharedVhd))
            {
                writer.WritePropertyName("hasSharedVhd"u8);
                writer.WriteStringValue(HasSharedVhd.Value.ToString());
            }
            if (Optional.IsDefined(HyperVHostId))
            {
                writer.WritePropertyName("hyperVHostId"u8);
                writer.WriteStringValue(HyperVHostId);
            }
        }

        HyperVVmDetails IJsonModel<HyperVVmDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVVmDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVVmDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHyperVVmDetails(document.RootElement, options);
        }

        internal static HyperVVmDetails DeserializeHyperVVmDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("instanceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "VmmVirtualMachine": return VmmVmDetails.DeserializeVmmVmDetails(element, options);
                }
            }
            string sourceItemId = default;
            string generation = default;
            SiteRecoveryOSDetails osDetails = default;
            IReadOnlyList<SiteRecoveryDiskDetails> diskDetails = default;
            HyperVVmDiskPresenceStatus? hasPhysicalDisk = default;
            HyperVVmDiskPresenceStatus? hasFibreChannelAdapter = default;
            HyperVVmDiskPresenceStatus? hasSharedVhd = default;
            string hyperVHostId = default;
            string instanceType = "HyperVVirtualMachine";
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sourceItemId"u8))
                {
                    sourceItemId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("generation"u8))
                {
                    generation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("osDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    osDetails = SiteRecoveryOSDetails.DeserializeSiteRecoveryOSDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("diskDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SiteRecoveryDiskDetails> array = new List<SiteRecoveryDiskDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SiteRecoveryDiskDetails.DeserializeSiteRecoveryDiskDetails(item, options));
                    }
                    diskDetails = array;
                    continue;
                }
                if (property.NameEquals("hasPhysicalDisk"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasPhysicalDisk = new HyperVVmDiskPresenceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("hasFibreChannelAdapter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasFibreChannelAdapter = new HyperVVmDiskPresenceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("hasSharedVhd"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasSharedVhd = new HyperVVmDiskPresenceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("hyperVHostId"u8))
                {
                    hyperVHostId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HyperVVmDetails(
                instanceType,
                serializedAdditionalRawData,
                sourceItemId,
                generation,
                osDetails,
                diskDetails ?? new ChangeTrackingList<SiteRecoveryDiskDetails>(),
                hasPhysicalDisk,
                hasFibreChannelAdapter,
                hasSharedVhd,
                hyperVHostId);
        }

        BinaryData IPersistableModel<HyperVVmDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVVmDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HyperVVmDetails)} does not support writing '{options.Format}' format.");
            }
        }

        HyperVVmDetails IPersistableModel<HyperVVmDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVVmDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHyperVVmDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HyperVVmDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HyperVVmDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
