// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. </summary>
    public readonly partial struct HyperVReplicaAzureRpRecoveryPointType : IEquatable<HyperVReplicaAzureRpRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HyperVReplicaAzureRpRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HyperVReplicaAzureRpRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestValue = "Latest";
        private const string LatestApplicationConsistentValue = "LatestApplicationConsistent";
        private const string LatestProcessedValue = "LatestProcessed";

        /// <summary> Latest. </summary>
        public static HyperVReplicaAzureRpRecoveryPointType Latest { get; } = new HyperVReplicaAzureRpRecoveryPointType(LatestValue);
        /// <summary> LatestApplicationConsistent. </summary>
        public static HyperVReplicaAzureRpRecoveryPointType LatestApplicationConsistent { get; } = new HyperVReplicaAzureRpRecoveryPointType(LatestApplicationConsistentValue);
        /// <summary> LatestProcessed. </summary>
        public static HyperVReplicaAzureRpRecoveryPointType LatestProcessed { get; } = new HyperVReplicaAzureRpRecoveryPointType(LatestProcessedValue);
        /// <summary> Determines if two <see cref="HyperVReplicaAzureRpRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(HyperVReplicaAzureRpRecoveryPointType left, HyperVReplicaAzureRpRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HyperVReplicaAzureRpRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(HyperVReplicaAzureRpRecoveryPointType left, HyperVReplicaAzureRpRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HyperVReplicaAzureRpRecoveryPointType"/>. </summary>
        public static implicit operator HyperVReplicaAzureRpRecoveryPointType(string value) => new HyperVReplicaAzureRpRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HyperVReplicaAzureRpRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HyperVReplicaAzureRpRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
