// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Azure specific reprotect input. </summary>
    public partial class HyperVReplicaAzureReprotectContent : ReverseReplicationProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="HyperVReplicaAzureReprotectContent"/>. </summary>
        public HyperVReplicaAzureReprotectContent()
        {
            InstanceType = "HyperVReplicaAzure";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVReplicaAzureReprotectContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="hyperVHostVmId"> The Hyper-V host Vm Id. </param>
        /// <param name="vmName"> The Vm Name. </param>
        /// <param name="osType"> The OS type associated with vm. </param>
        /// <param name="vhdId"> The OS disk VHD id associated with vm. </param>
        /// <param name="storageAccountId"> The storage account name. </param>
        /// <param name="logStorageAccountId"> The storage account to be used for logging during replication. </param>
        internal HyperVReplicaAzureReprotectContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string hyperVHostVmId, string vmName, string osType, string vhdId, ResourceIdentifier storageAccountId, ResourceIdentifier logStorageAccountId) : base(instanceType, serializedAdditionalRawData)
        {
            HyperVHostVmId = hyperVHostVmId;
            VmName = vmName;
            OSType = osType;
            VhdId = vhdId;
            StorageAccountId = storageAccountId;
            LogStorageAccountId = logStorageAccountId;
            InstanceType = instanceType ?? "HyperVReplicaAzure";
        }

        /// <summary> The Hyper-V host Vm Id. </summary>
        public string HyperVHostVmId { get; set; }
        /// <summary> The Vm Name. </summary>
        public string VmName { get; set; }
        /// <summary> The OS type associated with vm. </summary>
        public string OSType { get; set; }
        /// <summary> The OS disk VHD id associated with vm. </summary>
        public string VhdId { get; set; }
        /// <summary> The storage account name. </summary>
        public ResourceIdentifier StorageAccountId { get; set; }
        /// <summary> The storage account to be used for logging during replication. </summary>
        public ResourceIdentifier LogStorageAccountId { get; set; }
    }
}
