// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class HyperVReplicaAzureFailbackProviderContent : IUtf8JsonSerializable, IJsonModel<HyperVReplicaAzureFailbackProviderContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HyperVReplicaAzureFailbackProviderContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HyperVReplicaAzureFailbackProviderContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVReplicaAzureFailbackProviderContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVReplicaAzureFailbackProviderContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(DataSyncOption))
            {
                writer.WritePropertyName("dataSyncOption"u8);
                writer.WriteStringValue(DataSyncOption);
            }
            if (Optional.IsDefined(RecoveryVmCreationOption))
            {
                writer.WritePropertyName("recoveryVmCreationOption"u8);
                writer.WriteStringValue(RecoveryVmCreationOption);
            }
            if (Optional.IsDefined(ProviderIdForAlternateRecovery))
            {
                writer.WritePropertyName("providerIdForAlternateRecovery"u8);
                writer.WriteStringValue(ProviderIdForAlternateRecovery);
            }
        }

        HyperVReplicaAzureFailbackProviderContent IJsonModel<HyperVReplicaAzureFailbackProviderContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVReplicaAzureFailbackProviderContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVReplicaAzureFailbackProviderContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHyperVReplicaAzureFailbackProviderContent(document.RootElement, options);
        }

        internal static HyperVReplicaAzureFailbackProviderContent DeserializeHyperVReplicaAzureFailbackProviderContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dataSyncOption = default;
            string recoveryVmCreationOption = default;
            string providerIdForAlternateRecovery = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dataSyncOption"u8))
                {
                    dataSyncOption = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recoveryVmCreationOption"u8))
                {
                    recoveryVmCreationOption = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("providerIdForAlternateRecovery"u8))
                {
                    providerIdForAlternateRecovery = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HyperVReplicaAzureFailbackProviderContent(instanceType, serializedAdditionalRawData, dataSyncOption, recoveryVmCreationOption, providerIdForAlternateRecovery);
        }

        BinaryData IPersistableModel<HyperVReplicaAzureFailbackProviderContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVReplicaAzureFailbackProviderContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HyperVReplicaAzureFailbackProviderContent)} does not support writing '{options.Format}' format.");
            }
        }

        HyperVReplicaAzureFailbackProviderContent IPersistableModel<HyperVReplicaAzureFailbackProviderContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVReplicaAzureFailbackProviderContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHyperVReplicaAzureFailbackProviderContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HyperVReplicaAzureFailbackProviderContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HyperVReplicaAzureFailbackProviderContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
