// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The HyperVIPConfigDetails. </summary>
    public partial class HyperVIPConfigDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HyperVIPConfigDetails"/>. </summary>
        internal HyperVIPConfigDetails()
        {
            RecoveryLBBackendAddressPoolIds = new ChangeTrackingList<string>();
            TfoLBBackendAddressPoolIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HyperVIPConfigDetails"/>. </summary>
        /// <param name="name"></param>
        /// <param name="isPrimary"></param>
        /// <param name="subnetName"></param>
        /// <param name="staticIPAddress"></param>
        /// <param name="ipAddressType"></param>
        /// <param name="isSeletedForFailover"></param>
        /// <param name="recoverySubnetName"></param>
        /// <param name="recoveryStaticIPAddress"></param>
        /// <param name="recoveryIPAddressType"></param>
        /// <param name="recoveryPublicIPAddressId"></param>
        /// <param name="recoveryLBBackendAddressPoolIds"></param>
        /// <param name="tfoSubnetName"></param>
        /// <param name="tfoStaticIPAddress"></param>
        /// <param name="tfoPublicIPAddressId"></param>
        /// <param name="tfoLBBackendAddressPoolIds"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HyperVIPConfigDetails(string name, bool? isPrimary, string subnetName, IPAddress staticIPAddress, string ipAddressType, bool? isSeletedForFailover, string recoverySubnetName, IPAddress recoveryStaticIPAddress, string recoveryIPAddressType, ResourceIdentifier recoveryPublicIPAddressId, IReadOnlyList<string> recoveryLBBackendAddressPoolIds, string tfoSubnetName, IPAddress tfoStaticIPAddress, ResourceIdentifier tfoPublicIPAddressId, IReadOnlyList<string> tfoLBBackendAddressPoolIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IsPrimary = isPrimary;
            SubnetName = subnetName;
            StaticIPAddress = staticIPAddress;
            IPAddressType = ipAddressType;
            IsSeletedForFailover = isSeletedForFailover;
            RecoverySubnetName = recoverySubnetName;
            RecoveryStaticIPAddress = recoveryStaticIPAddress;
            RecoveryIPAddressType = recoveryIPAddressType;
            RecoveryPublicIPAddressId = recoveryPublicIPAddressId;
            RecoveryLBBackendAddressPoolIds = recoveryLBBackendAddressPoolIds;
            TfoSubnetName = tfoSubnetName;
            TfoStaticIPAddress = tfoStaticIPAddress;
            TfoPublicIPAddressId = tfoPublicIPAddressId;
            TfoLBBackendAddressPoolIds = tfoLBBackendAddressPoolIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the name. </summary>
        public string Name { get; }
        /// <summary> Gets the is primary. </summary>
        public bool? IsPrimary { get; }
        /// <summary> Gets the subnet name. </summary>
        public string SubnetName { get; }
        /// <summary> Gets the static ip address. </summary>
        public IPAddress StaticIPAddress { get; }
        /// <summary> Gets the ip address type. </summary>
        public string IPAddressType { get; }
        /// <summary> Gets the is seleted for failover. </summary>
        public bool? IsSeletedForFailover { get; }
        /// <summary> Gets the recovery subnet name. </summary>
        public string RecoverySubnetName { get; }
        /// <summary> Gets the recovery static ip address. </summary>
        public IPAddress RecoveryStaticIPAddress { get; }
        /// <summary> Gets the recovery ip address type. </summary>
        public string RecoveryIPAddressType { get; }
        /// <summary> Gets the recovery public ip address id. </summary>
        public ResourceIdentifier RecoveryPublicIPAddressId { get; }
        /// <summary> Gets the recovery lb backend address pool ids. </summary>
        public IReadOnlyList<string> RecoveryLBBackendAddressPoolIds { get; }
        /// <summary> Gets the tfo subnet name. </summary>
        public string TfoSubnetName { get; }
        /// <summary> Gets the tfo static ip address. </summary>
        public IPAddress TfoStaticIPAddress { get; }
        /// <summary> Gets the tfo public ip address id. </summary>
        public ResourceIdentifier TfoPublicIPAddressId { get; }
        /// <summary> Gets the tfo lb backend address pool ids. </summary>
        public IReadOnlyList<string> TfoLBBackendAddressPoolIds { get; }
    }
}
