// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> class to define the summary of the health error details. </summary>
    public partial class HealthErrorSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HealthErrorSummary"/>. </summary>
        internal HealthErrorSummary()
        {
            AffectedResourceCorrelationIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HealthErrorSummary"/>. </summary>
        /// <param name="summaryCode"> The code of the health error. </param>
        /// <param name="category"> The category of the health error. </param>
        /// <param name="severity"> Severity of error. </param>
        /// <param name="summaryMessage"> The summary message of the health error. </param>
        /// <param name="affectedResourceType"> The type of affected ARM resource. </param>
        /// <param name="affectedResourceSubtype"> The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable. </param>
        /// <param name="affectedResourceCorrelationIds"> The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific category and severity as well as count of item affected by an specific issue. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HealthErrorSummary(string summaryCode, HealthErrorCategory? category, SiteRecoveryErrorSeverity? severity, string summaryMessage, string affectedResourceType, string affectedResourceSubtype, IReadOnlyList<string> affectedResourceCorrelationIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SummaryCode = summaryCode;
            Category = category;
            Severity = severity;
            SummaryMessage = summaryMessage;
            AffectedResourceType = affectedResourceType;
            AffectedResourceSubtype = affectedResourceSubtype;
            AffectedResourceCorrelationIds = affectedResourceCorrelationIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The code of the health error. </summary>
        public string SummaryCode { get; }
        /// <summary> The category of the health error. </summary>
        public HealthErrorCategory? Category { get; }
        /// <summary> Severity of error. </summary>
        public SiteRecoveryErrorSeverity? Severity { get; }
        /// <summary> The summary message of the health error. </summary>
        public string SummaryMessage { get; }
        /// <summary> The type of affected ARM resource. </summary>
        public string AffectedResourceType { get; }
        /// <summary> The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable. </summary>
        public string AffectedResourceSubtype { get; }
        /// <summary> The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific category and severity as well as count of item affected by an specific issue. </summary>
        public IReadOnlyList<string> AffectedResourceCorrelationIds { get; }
    }
}
