// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class HealthErrorSummary : IUtf8JsonSerializable, IJsonModel<HealthErrorSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HealthErrorSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HealthErrorSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthErrorSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HealthErrorSummary)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(SummaryCode))
            {
                writer.WritePropertyName("summaryCode"u8);
                writer.WriteStringValue(SummaryCode);
            }
            if (Optional.IsDefined(Category))
            {
                writer.WritePropertyName("category"u8);
                writer.WriteStringValue(Category.Value.ToString());
            }
            if (Optional.IsDefined(Severity))
            {
                writer.WritePropertyName("severity"u8);
                writer.WriteStringValue(Severity.Value.ToString());
            }
            if (Optional.IsDefined(SummaryMessage))
            {
                writer.WritePropertyName("summaryMessage"u8);
                writer.WriteStringValue(SummaryMessage);
            }
            if (Optional.IsDefined(AffectedResourceType))
            {
                writer.WritePropertyName("affectedResourceType"u8);
                writer.WriteStringValue(AffectedResourceType);
            }
            if (Optional.IsDefined(AffectedResourceSubtype))
            {
                writer.WritePropertyName("affectedResourceSubtype"u8);
                writer.WriteStringValue(AffectedResourceSubtype);
            }
            if (Optional.IsCollectionDefined(AffectedResourceCorrelationIds))
            {
                writer.WritePropertyName("affectedResourceCorrelationIds"u8);
                writer.WriteStartArray();
                foreach (var item in AffectedResourceCorrelationIds)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HealthErrorSummary IJsonModel<HealthErrorSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthErrorSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HealthErrorSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHealthErrorSummary(document.RootElement, options);
        }

        internal static HealthErrorSummary DeserializeHealthErrorSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string summaryCode = default;
            HealthErrorCategory? category = default;
            SiteRecoveryErrorSeverity? severity = default;
            string summaryMessage = default;
            string affectedResourceType = default;
            string affectedResourceSubtype = default;
            IReadOnlyList<string> affectedResourceCorrelationIds = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summaryCode"u8))
                {
                    summaryCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    category = new HealthErrorCategory(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("severity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    severity = new SiteRecoveryErrorSeverity(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("summaryMessage"u8))
                {
                    summaryMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("affectedResourceType"u8))
                {
                    affectedResourceType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("affectedResourceSubtype"u8))
                {
                    affectedResourceSubtype = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("affectedResourceCorrelationIds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    affectedResourceCorrelationIds = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HealthErrorSummary(
                summaryCode,
                category,
                severity,
                summaryMessage,
                affectedResourceType,
                affectedResourceSubtype,
                affectedResourceCorrelationIds ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HealthErrorSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthErrorSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HealthErrorSummary)} does not support writing '{options.Format}' format.");
            }
        }

        HealthErrorSummary IPersistableModel<HealthErrorSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HealthErrorSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHealthErrorSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HealthErrorSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HealthErrorSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
