// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Value indicating whether the health error is customer resolvable. </summary>
    public readonly partial struct HealthErrorCustomerResolvability : IEquatable<HealthErrorCustomerResolvability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthErrorCustomerResolvability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthErrorCustomerResolvability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowedValue = "Allowed";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Allowed. </summary>
        public static HealthErrorCustomerResolvability Allowed { get; } = new HealthErrorCustomerResolvability(AllowedValue);
        /// <summary> NotAllowed. </summary>
        public static HealthErrorCustomerResolvability NotAllowed { get; } = new HealthErrorCustomerResolvability(NotAllowedValue);
        /// <summary> Determines if two <see cref="HealthErrorCustomerResolvability"/> values are the same. </summary>
        public static bool operator ==(HealthErrorCustomerResolvability left, HealthErrorCustomerResolvability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthErrorCustomerResolvability"/> values are not the same. </summary>
        public static bool operator !=(HealthErrorCustomerResolvability left, HealthErrorCustomerResolvability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthErrorCustomerResolvability"/>. </summary>
        public static implicit operator HealthErrorCustomerResolvability(string value) => new HealthErrorCustomerResolvability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthErrorCustomerResolvability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthErrorCustomerResolvability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
