// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The failover deployment model. </summary>
    public readonly partial struct FailoverDeploymentModel : IEquatable<FailoverDeploymentModel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FailoverDeploymentModel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FailoverDeploymentModel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotApplicableValue = "NotApplicable";
        private const string ClassicValue = "Classic";
        private const string ResourceManagerValue = "ResourceManager";

        /// <summary> NotApplicable. </summary>
        public static FailoverDeploymentModel NotApplicable { get; } = new FailoverDeploymentModel(NotApplicableValue);
        /// <summary> Classic. </summary>
        public static FailoverDeploymentModel Classic { get; } = new FailoverDeploymentModel(ClassicValue);
        /// <summary> ResourceManager. </summary>
        public static FailoverDeploymentModel ResourceManager { get; } = new FailoverDeploymentModel(ResourceManagerValue);
        /// <summary> Determines if two <see cref="FailoverDeploymentModel"/> values are the same. </summary>
        public static bool operator ==(FailoverDeploymentModel left, FailoverDeploymentModel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FailoverDeploymentModel"/> values are not the same. </summary>
        public static bool operator !=(FailoverDeploymentModel left, FailoverDeploymentModel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FailoverDeploymentModel"/>. </summary>
        public static implicit operator FailoverDeploymentModel(string value) => new FailoverDeploymentModel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FailoverDeploymentModel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FailoverDeploymentModel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
