// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    [PersistableModelProxy(typeof(UnknownFabricSpecificUpdateNetworkMappingContent))]
    public partial class FabricSpecificUpdateNetworkMappingContent : IUtf8JsonSerializable, IJsonModel<FabricSpecificUpdateNetworkMappingContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FabricSpecificUpdateNetworkMappingContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FabricSpecificUpdateNetworkMappingContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificUpdateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FabricSpecificUpdateNetworkMappingContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("instanceType"u8);
            writer.WriteStringValue(InstanceType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FabricSpecificUpdateNetworkMappingContent IJsonModel<FabricSpecificUpdateNetworkMappingContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificUpdateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FabricSpecificUpdateNetworkMappingContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFabricSpecificUpdateNetworkMappingContent(document.RootElement, options);
        }

        internal static FabricSpecificUpdateNetworkMappingContent DeserializeFabricSpecificUpdateNetworkMappingContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("instanceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AzureToAzure": return A2AUpdateNetworkMappingContent.DeserializeA2AUpdateNetworkMappingContent(element, options);
                    case "VmmToAzure": return VmmToAzureUpdateNetworkMappingContent.DeserializeVmmToAzureUpdateNetworkMappingContent(element, options);
                    case "VmmToVmm": return VmmToVmmUpdateNetworkMappingContent.DeserializeVmmToVmmUpdateNetworkMappingContent(element, options);
                }
            }
            return UnknownFabricSpecificUpdateNetworkMappingContent.DeserializeUnknownFabricSpecificUpdateNetworkMappingContent(element, options);
        }

        BinaryData IPersistableModel<FabricSpecificUpdateNetworkMappingContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificUpdateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FabricSpecificUpdateNetworkMappingContent)} does not support writing '{options.Format}' format.");
            }
        }

        FabricSpecificUpdateNetworkMappingContent IPersistableModel<FabricSpecificUpdateNetworkMappingContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificUpdateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFabricSpecificUpdateNetworkMappingContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FabricSpecificUpdateNetworkMappingContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FabricSpecificUpdateNetworkMappingContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
