// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    [PersistableModelProxy(typeof(UnknownFabricSpecificCreateNetworkMappingContent))]
    public partial class FabricSpecificCreateNetworkMappingContent : IUtf8JsonSerializable, IJsonModel<FabricSpecificCreateNetworkMappingContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FabricSpecificCreateNetworkMappingContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FabricSpecificCreateNetworkMappingContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificCreateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FabricSpecificCreateNetworkMappingContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("instanceType"u8);
            writer.WriteStringValue(InstanceType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FabricSpecificCreateNetworkMappingContent IJsonModel<FabricSpecificCreateNetworkMappingContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificCreateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FabricSpecificCreateNetworkMappingContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFabricSpecificCreateNetworkMappingContent(document.RootElement, options);
        }

        internal static FabricSpecificCreateNetworkMappingContent DeserializeFabricSpecificCreateNetworkMappingContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("instanceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AzureToAzure": return A2ACreateNetworkMappingContent.DeserializeA2ACreateNetworkMappingContent(element, options);
                    case "VmmToAzure": return VmmToAzureCreateNetworkMappingContent.DeserializeVmmToAzureCreateNetworkMappingContent(element, options);
                    case "VmmToVmm": return VmmToVmmCreateNetworkMappingContent.DeserializeVmmToVmmCreateNetworkMappingContent(element, options);
                }
            }
            return UnknownFabricSpecificCreateNetworkMappingContent.DeserializeUnknownFabricSpecificCreateNetworkMappingContent(element, options);
        }

        BinaryData IPersistableModel<FabricSpecificCreateNetworkMappingContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificCreateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FabricSpecificCreateNetworkMappingContent)} does not support writing '{options.Format}' format.");
            }
        }

        FabricSpecificCreateNetworkMappingContent IPersistableModel<FabricSpecificCreateNetworkMappingContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FabricSpecificCreateNetworkMappingContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFabricSpecificCreateNetworkMappingContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FabricSpecificCreateNetworkMappingContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FabricSpecificCreateNetworkMappingContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
