// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The output type of the jobs. </summary>
    public readonly partial struct ExportJobOutputSerializationType : IEquatable<ExportJobOutputSerializationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportJobOutputSerializationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportJobOutputSerializationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JsonValue = "Json";
        private const string XmlValue = "Xml";
        private const string ExcelValue = "Excel";

        /// <summary> Json. </summary>
        public static ExportJobOutputSerializationType Json { get; } = new ExportJobOutputSerializationType(JsonValue);
        /// <summary> Xml. </summary>
        public static ExportJobOutputSerializationType Xml { get; } = new ExportJobOutputSerializationType(XmlValue);
        /// <summary> Excel. </summary>
        public static ExportJobOutputSerializationType Excel { get; } = new ExportJobOutputSerializationType(ExcelValue);
        /// <summary> Determines if two <see cref="ExportJobOutputSerializationType"/> values are the same. </summary>
        public static bool operator ==(ExportJobOutputSerializationType left, ExportJobOutputSerializationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportJobOutputSerializationType"/> values are not the same. </summary>
        public static bool operator !=(ExportJobOutputSerializationType left, ExportJobOutputSerializationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportJobOutputSerializationType"/>. </summary>
        public static implicit operator ExportJobOutputSerializationType(string value) => new ExportJobOutputSerializationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportJobOutputSerializationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportJobOutputSerializationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
