// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Existing recovery proximity placement group input. </summary>
    public partial class ExistingRecoveryProximityPlacementGroup : RecoveryProximityPlacementGroupCustomDetails
    {
        /// <summary> Initializes a new instance of <see cref="ExistingRecoveryProximityPlacementGroup"/>. </summary>
        public ExistingRecoveryProximityPlacementGroup()
        {
            ResourceType = "Existing";
        }

        /// <summary> Initializes a new instance of <see cref="ExistingRecoveryProximityPlacementGroup"/>. </summary>
        /// <param name="resourceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryProximityPlacementGroupId"> The recovery proximity placement group Id. Will throw error, if resource does not exist. </param>
        internal ExistingRecoveryProximityPlacementGroup(string resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier recoveryProximityPlacementGroupId) : base(resourceType, serializedAdditionalRawData)
        {
            RecoveryProximityPlacementGroupId = recoveryProximityPlacementGroupId;
            ResourceType = resourceType ?? "Existing";
        }

        /// <summary> The recovery proximity placement group Id. Will throw error, if resource does not exist. </summary>
        public ResourceIdentifier RecoveryProximityPlacementGroupId { get; set; }
    }
}
