// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Enable protection input properties. </summary>
    public partial class EnableProtectionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EnableProtectionProperties"/>. </summary>
        public EnableProtectionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EnableProtectionProperties"/>. </summary>
        /// <param name="policyId"> The Policy Id. </param>
        /// <param name="protectableItemId"> The protectable item Id. </param>
        /// <param name="providerSpecificDetails">
        /// The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
        /// Please note <see cref="EnableProtectionProviderSpecificContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2AEnableProtectionContent"/>, <see cref="A2ACrossClusterMigrationEnableProtectionContent"/>, <see cref="HyperVReplicaAzureEnableProtectionContent"/>, <see cref="InMageEnableProtectionContent"/>, <see cref="InMageAzureV2EnableProtectionContent"/> and <see cref="InMageRcmEnableProtectionContent"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EnableProtectionProperties(ResourceIdentifier policyId, ResourceIdentifier protectableItemId, EnableProtectionProviderSpecificContent providerSpecificDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyId = policyId;
            ProtectableItemId = protectableItemId;
            ProviderSpecificDetails = providerSpecificDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Policy Id. </summary>
        public ResourceIdentifier PolicyId { get; set; }
        /// <summary> The protectable item Id. </summary>
        public ResourceIdentifier ProtectableItemId { get; set; }
        /// <summary>
        /// The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
        /// Please note <see cref="EnableProtectionProviderSpecificContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2AEnableProtectionContent"/>, <see cref="A2ACrossClusterMigrationEnableProtectionContent"/>, <see cref="HyperVReplicaAzureEnableProtectionContent"/>, <see cref="InMageEnableProtectionContent"/>, <see cref="InMageAzureV2EnableProtectionContent"/> and <see cref="InMageRcmEnableProtectionContent"/>.
        /// </summary>
        public EnableProtectionProviderSpecificContent ProviderSpecificDetails { get; set; }
    }
}
