// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Current job details of the migration item. </summary>
    public partial class CurrentJobDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CurrentJobDetails"/>. </summary>
        internal CurrentJobDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CurrentJobDetails"/>. </summary>
        /// <param name="jobName"> The job name. </param>
        /// <param name="jobId"> The ARM Id of the job being executed. </param>
        /// <param name="startOn"> The start time of the job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CurrentJobDetails(string jobName, ResourceIdentifier jobId, DateTimeOffset? startOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            JobName = jobName;
            JobId = jobId;
            StartOn = startOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The job name. </summary>
        public string JobName { get; }
        /// <summary> The ARM Id of the job being executed. </summary>
        public ResourceIdentifier JobId { get; }
        /// <summary> The start time of the job. </summary>
        public DateTimeOffset? StartOn { get; }
    }
}
