// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> This class contains monitoring details of all the inconsistent Protected Entities in Vmm. </summary>
    public partial class ConsistencyCheckTaskDetails : SiteRecoveryTaskTypeDetails
    {
        /// <summary> Initializes a new instance of <see cref="ConsistencyCheckTaskDetails"/>. </summary>
        internal ConsistencyCheckTaskDetails()
        {
            VmDetails = new ChangeTrackingList<InconsistentVmDetails>();
            InstanceType = "ConsistencyCheckTaskDetails";
        }

        /// <summary> Initializes a new instance of <see cref="ConsistencyCheckTaskDetails"/>. </summary>
        /// <param name="instanceType"> The type of task details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="vmDetails"> The list of inconsistent Vm details. </param>
        internal ConsistencyCheckTaskDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<InconsistentVmDetails> vmDetails) : base(instanceType, serializedAdditionalRawData)
        {
            VmDetails = vmDetails;
            InstanceType = instanceType ?? "ConsistencyCheckTaskDetails";
        }

        /// <summary> The list of inconsistent Vm details. </summary>
        public IReadOnlyList<InconsistentVmDetails> VmDetails { get; }
    }
}
