// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Task of the Job. </summary>
    public partial class AsrTask
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AsrTask"/>. </summary>
        internal AsrTask()
        {
            AllowedActions = new ChangeTrackingList<string>();
            Errors = new ChangeTrackingList<SiteRecoveryJobErrorDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="AsrTask"/>. </summary>
        /// <param name="taskId"> The Id. </param>
        /// <param name="name"> The unique Task name. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="allowedActions"> The state/actions applicable on this task. </param>
        /// <param name="friendlyName"> The name. </param>
        /// <param name="state"> The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other. </param>
        /// <param name="stateDescription"> The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped. </param>
        /// <param name="taskType"> The type of task. Details in CustomDetails property depend on this type. </param>
        /// <param name="customDetails">
        /// The custom task details based on the task type.
        /// Please note <see cref="SiteRecoveryTaskTypeDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AutomationRunbookTaskDetails"/>, <see cref="ConsistencyCheckTaskDetails"/>, <see cref="FabricReplicationGroupTaskDetails"/>, <see cref="SiteRecoveryJobTaskDetails"/>, <see cref="ManualActionTaskDetails"/>, <see cref="ScriptActionTaskDetails"/>, <see cref="SiteRecoveryVmTaskDetails"/> and <see cref="VmNicUpdatesTaskDetails"/>.
        /// </param>
        /// <param name="groupTaskCustomDetails">
        /// The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
        /// Please note <see cref="SiteRecoveryGroupTaskDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="InlineWorkflowTaskDetails"/>, <see cref="RecoveryPlanGroupTaskDetails"/> and <see cref="RecoveryPlanShutdownGroupTaskDetails"/>.
        /// </param>
        /// <param name="errors"> The task error details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AsrTask(string taskId, string name, DateTimeOffset? startOn, DateTimeOffset? endOn, IReadOnlyList<string> allowedActions, string friendlyName, string state, string stateDescription, string taskType, SiteRecoveryTaskTypeDetails customDetails, SiteRecoveryGroupTaskDetails groupTaskCustomDetails, IReadOnlyList<SiteRecoveryJobErrorDetails> errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TaskId = taskId;
            Name = name;
            StartOn = startOn;
            EndOn = endOn;
            AllowedActions = allowedActions;
            FriendlyName = friendlyName;
            State = state;
            StateDescription = stateDescription;
            TaskType = taskType;
            CustomDetails = customDetails;
            GroupTaskCustomDetails = groupTaskCustomDetails;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Id. </summary>
        public string TaskId { get; }
        /// <summary> The unique Task name. </summary>
        public string Name { get; }
        /// <summary> The start time. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The end time. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> The state/actions applicable on this task. </summary>
        public IReadOnlyList<string> AllowedActions { get; }
        /// <summary> The name. </summary>
        public string FriendlyName { get; }
        /// <summary> The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other. </summary>
        public string State { get; }
        /// <summary> The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped. </summary>
        public string StateDescription { get; }
        /// <summary> The type of task. Details in CustomDetails property depend on this type. </summary>
        public string TaskType { get; }
        /// <summary>
        /// The custom task details based on the task type.
        /// Please note <see cref="SiteRecoveryTaskTypeDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AutomationRunbookTaskDetails"/>, <see cref="ConsistencyCheckTaskDetails"/>, <see cref="FabricReplicationGroupTaskDetails"/>, <see cref="SiteRecoveryJobTaskDetails"/>, <see cref="ManualActionTaskDetails"/>, <see cref="ScriptActionTaskDetails"/>, <see cref="SiteRecoveryVmTaskDetails"/> and <see cref="VmNicUpdatesTaskDetails"/>.
        /// </summary>
        public SiteRecoveryTaskTypeDetails CustomDetails { get; }
        /// <summary>
        /// The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
        /// Please note <see cref="SiteRecoveryGroupTaskDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="InlineWorkflowTaskDetails"/>, <see cref="RecoveryPlanGroupTaskDetails"/> and <see cref="RecoveryPlanShutdownGroupTaskDetails"/>.
        /// </summary>
        public SiteRecoveryGroupTaskDetails GroupTaskCustomDetails { get; }
        /// <summary> The task error details. </summary>
        public IReadOnlyList<SiteRecoveryJobErrorDetails> Errors { get; }
    }
}
