// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Details of the appliance resource. </summary>
    public partial class ApplianceResourceDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplianceResourceDetails"/>. </summary>
        internal ApplianceResourceDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApplianceResourceDetails"/>. </summary>
        /// <param name="capacity"> A value indicating the total capacity of appliance resource. </param>
        /// <param name="processUtilization"> A value indicating the utilization percentage by gateway agent on appliance. </param>
        /// <param name="totalUtilization"> A value indicating the total utilization percentage for all processes on the appliance. </param>
        /// <param name="status"> A value indicating the status of appliance resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplianceResourceDetails(long? capacity, double? processUtilization, double? totalUtilization, string status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Capacity = capacity;
            ProcessUtilization = processUtilization;
            TotalUtilization = totalUtilization;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A value indicating the total capacity of appliance resource. </summary>
        public long? Capacity { get; }
        /// <summary> A value indicating the utilization percentage by gateway agent on appliance. </summary>
        public double? ProcessUtilization { get; }
        /// <summary> A value indicating the total utilization percentage for all processes on the appliance. </summary>
        public double? TotalUtilization { get; }
        /// <summary> A value indicating the status of appliance resource. </summary>
        public string Status { get; }
    }
}
