// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The ALR option. </summary>
    public readonly partial struct AlternateLocationRecoveryOption : IEquatable<AlternateLocationRecoveryOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AlternateLocationRecoveryOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AlternateLocationRecoveryOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateVmIfNotFoundValue = "CreateVmIfNotFound";
        private const string NoActionValue = "NoAction";

        /// <summary> CreateVmIfNotFound. </summary>
        public static AlternateLocationRecoveryOption CreateVmIfNotFound { get; } = new AlternateLocationRecoveryOption(CreateVmIfNotFoundValue);
        /// <summary> NoAction. </summary>
        public static AlternateLocationRecoveryOption NoAction { get; } = new AlternateLocationRecoveryOption(NoActionValue);
        /// <summary> Determines if two <see cref="AlternateLocationRecoveryOption"/> values are the same. </summary>
        public static bool operator ==(AlternateLocationRecoveryOption left, AlternateLocationRecoveryOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AlternateLocationRecoveryOption"/> values are not the same. </summary>
        public static bool operator !=(AlternateLocationRecoveryOption left, AlternateLocationRecoveryOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AlternateLocationRecoveryOption"/>. </summary>
        public static implicit operator AlternateLocationRecoveryOption(string value) => new AlternateLocationRecoveryOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AlternateLocationRecoveryOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AlternateLocationRecoveryOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
