// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A2A Vm managed disk update details. </summary>
    public partial class A2AVmManagedDiskUpdateDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="A2AVmManagedDiskUpdateDetails"/>. </summary>
        public A2AVmManagedDiskUpdateDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="A2AVmManagedDiskUpdateDetails"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="recoveryTargetDiskAccountType"> The target disk type before failover. </param>
        /// <param name="recoveryReplicaDiskAccountType"> The replica disk type before failover. </param>
        /// <param name="diskEncryptionInfo"> The recovery os disk encryption information. </param>
        /// <param name="failoverDiskName"> The target disk name for unplanned failover operation. </param>
        /// <param name="tfoDiskName"> The target disk name for test failover operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal A2AVmManagedDiskUpdateDetails(string diskId, string recoveryTargetDiskAccountType, string recoveryReplicaDiskAccountType, SiteRecoveryDiskEncryptionInfo diskEncryptionInfo, string failoverDiskName, string tfoDiskName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiskId = diskId;
            RecoveryTargetDiskAccountType = recoveryTargetDiskAccountType;
            RecoveryReplicaDiskAccountType = recoveryReplicaDiskAccountType;
            DiskEncryptionInfo = diskEncryptionInfo;
            FailoverDiskName = failoverDiskName;
            TfoDiskName = tfoDiskName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The disk Id. </summary>
        public string DiskId { get; set; }
        /// <summary> The target disk type before failover. </summary>
        public string RecoveryTargetDiskAccountType { get; set; }
        /// <summary> The replica disk type before failover. </summary>
        public string RecoveryReplicaDiskAccountType { get; set; }
        /// <summary> The recovery os disk encryption information. </summary>
        public SiteRecoveryDiskEncryptionInfo DiskEncryptionInfo { get; set; }
        /// <summary> The target disk name for unplanned failover operation. </summary>
        public string FailoverDiskName { get; set; }
        /// <summary> The target disk name for test failover operation. </summary>
        public string TfoDiskName { get; set; }
    }
}
