// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A2A update protection container mapping. </summary>
    public partial class A2AUpdateContainerMappingContent : ReplicationProviderSpecificUpdateContainerMappingContent
    {
        /// <summary> Initializes a new instance of <see cref="A2AUpdateContainerMappingContent"/>. </summary>
        public A2AUpdateContainerMappingContent()
        {
            InstanceType = "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2AUpdateContainerMappingContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="agentAutoUpdateStatus"> A value indicating whether the auto update is enabled. </param>
        /// <param name="automationAccountArmId"> The automation account arm id. </param>
        /// <param name="automationAccountAuthenticationType"> A value indicating the type authentication to use for automation Account. </param>
        internal A2AUpdateContainerMappingContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, SiteRecoveryAgentAutoUpdateStatus? agentAutoUpdateStatus, ResourceIdentifier automationAccountArmId, AutomationAccountAuthenticationType? automationAccountAuthenticationType) : base(instanceType, serializedAdditionalRawData)
        {
            AgentAutoUpdateStatus = agentAutoUpdateStatus;
            AutomationAccountArmId = automationAccountArmId;
            AutomationAccountAuthenticationType = automationAccountAuthenticationType;
            InstanceType = instanceType ?? "A2A";
        }

        /// <summary> A value indicating whether the auto update is enabled. </summary>
        public SiteRecoveryAgentAutoUpdateStatus? AgentAutoUpdateStatus { get; set; }
        /// <summary> The automation account arm id. </summary>
        public ResourceIdentifier AutomationAccountArmId { get; set; }
        /// <summary> A value indicating the type authentication to use for automation Account. </summary>
        public AutomationAccountAuthenticationType? AutomationAccountAuthenticationType { get; set; }
    }
}
